// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package vulnerabilityscanning

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// ListVulnerabilitiesRequest wrapper for the ListVulnerabilities operation
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListVulnerabilities.go.html to see an example of how to use ListVulnerabilitiesRequest.
type ListVulnerabilitiesRequest struct {

	// The ID of the compartment in which to list resources.
	CompartmentId *string `mandatory:"true" contributesTo:"query" name:"compartmentId"`

	// The maximum number of items to return.
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// A filter to return only resources that have a severity that matches the given severity
	Severity ListVulnerabilitiesSeverityEnum `mandatory:"false" contributesTo:"query" name:"severity" omitEmpty:"true"`

	// A filter to return only resources that match the entire name given.
	Name *string `mandatory:"false" contributesTo:"query" name:"name"`

	// Parameter to filter the vulnerability type's unique identifier. For CVE, this is the MITRE CVE ID
	VulnerabilityReference *string `mandatory:"false" contributesTo:"query" name:"vulnerabilityReference"`

	// The field to filter vulnerabilities based on its type. Only one value can be provided.
	VulnerabilityType ListVulnerabilitiesVulnerabilityTypeEnum `mandatory:"false" contributesTo:"query" name:"vulnerabilityType" omitEmpty:"true"`

	// The sort order to use, either 'ASC' or 'DESC'.
	SortOrder ListVulnerabilitiesSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// The field to sort by. Only one sort order may be provided. Default order for 'name' is Ascending. Default order for other values is descending. If no value is specified name is default.
	SortBy ListVulnerabilitiesSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// The client request ID for tracing.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListVulnerabilitiesRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListVulnerabilitiesRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request ListVulnerabilitiesRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListVulnerabilitiesRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request ListVulnerabilitiesRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingListVulnerabilitiesSeverityEnum(string(request.Severity)); !ok && request.Severity != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for Severity: %s. Supported values are: %s.", request.Severity, strings.Join(GetListVulnerabilitiesSeverityEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListVulnerabilitiesVulnerabilityTypeEnum(string(request.VulnerabilityType)); !ok && request.VulnerabilityType != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for VulnerabilityType: %s. Supported values are: %s.", request.VulnerabilityType, strings.Join(GetListVulnerabilitiesVulnerabilityTypeEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListVulnerabilitiesSortOrderEnum(string(request.SortOrder)); !ok && request.SortOrder != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortOrder: %s. Supported values are: %s.", request.SortOrder, strings.Join(GetListVulnerabilitiesSortOrderEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListVulnerabilitiesSortByEnum(string(request.SortBy)); !ok && request.SortBy != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortBy: %s. Supported values are: %s.", request.SortBy, strings.Join(GetListVulnerabilitiesSortByEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ListVulnerabilitiesResponse wrapper for the ListVulnerabilities operation
type ListVulnerabilitiesResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of VulnerabilitySummaryCollection instances
	VulnerabilitySummaryCollection `presentIn:"body"`

	// Unique Oracle-assigned identifier for the request. If you need to contact
	// Oracle about a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`

	// For pagination of a list of items. When paging through a list, if this header appears in the response,
	// then a partial list might have been returned. Include this value as the `page` parameter for the
	// subsequent GET request to get the next batch of items.
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`
}

func (response ListVulnerabilitiesResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListVulnerabilitiesResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListVulnerabilitiesSeverityEnum Enum with underlying type: string
type ListVulnerabilitiesSeverityEnum string

// Set of constants representing the allowable values for ListVulnerabilitiesSeverityEnum
const (
	ListVulnerabilitiesSeverityNone     ListVulnerabilitiesSeverityEnum = "NONE"
	ListVulnerabilitiesSeverityLow      ListVulnerabilitiesSeverityEnum = "LOW"
	ListVulnerabilitiesSeverityMedium   ListVulnerabilitiesSeverityEnum = "MEDIUM"
	ListVulnerabilitiesSeverityHigh     ListVulnerabilitiesSeverityEnum = "HIGH"
	ListVulnerabilitiesSeverityCritical ListVulnerabilitiesSeverityEnum = "CRITICAL"
)

var mappingListVulnerabilitiesSeverityEnum = map[string]ListVulnerabilitiesSeverityEnum{
	"NONE":     ListVulnerabilitiesSeverityNone,
	"LOW":      ListVulnerabilitiesSeverityLow,
	"MEDIUM":   ListVulnerabilitiesSeverityMedium,
	"HIGH":     ListVulnerabilitiesSeverityHigh,
	"CRITICAL": ListVulnerabilitiesSeverityCritical,
}

var mappingListVulnerabilitiesSeverityEnumLowerCase = map[string]ListVulnerabilitiesSeverityEnum{
	"none":     ListVulnerabilitiesSeverityNone,
	"low":      ListVulnerabilitiesSeverityLow,
	"medium":   ListVulnerabilitiesSeverityMedium,
	"high":     ListVulnerabilitiesSeverityHigh,
	"critical": ListVulnerabilitiesSeverityCritical,
}

// GetListVulnerabilitiesSeverityEnumValues Enumerates the set of values for ListVulnerabilitiesSeverityEnum
func GetListVulnerabilitiesSeverityEnumValues() []ListVulnerabilitiesSeverityEnum {
	values := make([]ListVulnerabilitiesSeverityEnum, 0)
	for _, v := range mappingListVulnerabilitiesSeverityEnum {
		values = append(values, v)
	}
	return values
}

// GetListVulnerabilitiesSeverityEnumStringValues Enumerates the set of values in String for ListVulnerabilitiesSeverityEnum
func GetListVulnerabilitiesSeverityEnumStringValues() []string {
	return []string{
		"NONE",
		"LOW",
		"MEDIUM",
		"HIGH",
		"CRITICAL",
	}
}

// GetMappingListVulnerabilitiesSeverityEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListVulnerabilitiesSeverityEnum(val string) (ListVulnerabilitiesSeverityEnum, bool) {
	enum, ok := mappingListVulnerabilitiesSeverityEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListVulnerabilitiesVulnerabilityTypeEnum Enum with underlying type: string
type ListVulnerabilitiesVulnerabilityTypeEnum string

// Set of constants representing the allowable values for ListVulnerabilitiesVulnerabilityTypeEnum
const (
	ListVulnerabilitiesVulnerabilityTypeCve     ListVulnerabilitiesVulnerabilityTypeEnum = "CVE"
	ListVulnerabilitiesVulnerabilityTypeProblem ListVulnerabilitiesVulnerabilityTypeEnum = "PROBLEM"
)

var mappingListVulnerabilitiesVulnerabilityTypeEnum = map[string]ListVulnerabilitiesVulnerabilityTypeEnum{
	"CVE":     ListVulnerabilitiesVulnerabilityTypeCve,
	"PROBLEM": ListVulnerabilitiesVulnerabilityTypeProblem,
}

var mappingListVulnerabilitiesVulnerabilityTypeEnumLowerCase = map[string]ListVulnerabilitiesVulnerabilityTypeEnum{
	"cve":     ListVulnerabilitiesVulnerabilityTypeCve,
	"problem": ListVulnerabilitiesVulnerabilityTypeProblem,
}

// GetListVulnerabilitiesVulnerabilityTypeEnumValues Enumerates the set of values for ListVulnerabilitiesVulnerabilityTypeEnum
func GetListVulnerabilitiesVulnerabilityTypeEnumValues() []ListVulnerabilitiesVulnerabilityTypeEnum {
	values := make([]ListVulnerabilitiesVulnerabilityTypeEnum, 0)
	for _, v := range mappingListVulnerabilitiesVulnerabilityTypeEnum {
		values = append(values, v)
	}
	return values
}

// GetListVulnerabilitiesVulnerabilityTypeEnumStringValues Enumerates the set of values in String for ListVulnerabilitiesVulnerabilityTypeEnum
func GetListVulnerabilitiesVulnerabilityTypeEnumStringValues() []string {
	return []string{
		"CVE",
		"PROBLEM",
	}
}

// GetMappingListVulnerabilitiesVulnerabilityTypeEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListVulnerabilitiesVulnerabilityTypeEnum(val string) (ListVulnerabilitiesVulnerabilityTypeEnum, bool) {
	enum, ok := mappingListVulnerabilitiesVulnerabilityTypeEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListVulnerabilitiesSortOrderEnum Enum with underlying type: string
type ListVulnerabilitiesSortOrderEnum string

// Set of constants representing the allowable values for ListVulnerabilitiesSortOrderEnum
const (
	ListVulnerabilitiesSortOrderAsc  ListVulnerabilitiesSortOrderEnum = "ASC"
	ListVulnerabilitiesSortOrderDesc ListVulnerabilitiesSortOrderEnum = "DESC"
)

var mappingListVulnerabilitiesSortOrderEnum = map[string]ListVulnerabilitiesSortOrderEnum{
	"ASC":  ListVulnerabilitiesSortOrderAsc,
	"DESC": ListVulnerabilitiesSortOrderDesc,
}

var mappingListVulnerabilitiesSortOrderEnumLowerCase = map[string]ListVulnerabilitiesSortOrderEnum{
	"asc":  ListVulnerabilitiesSortOrderAsc,
	"desc": ListVulnerabilitiesSortOrderDesc,
}

// GetListVulnerabilitiesSortOrderEnumValues Enumerates the set of values for ListVulnerabilitiesSortOrderEnum
func GetListVulnerabilitiesSortOrderEnumValues() []ListVulnerabilitiesSortOrderEnum {
	values := make([]ListVulnerabilitiesSortOrderEnum, 0)
	for _, v := range mappingListVulnerabilitiesSortOrderEnum {
		values = append(values, v)
	}
	return values
}

// GetListVulnerabilitiesSortOrderEnumStringValues Enumerates the set of values in String for ListVulnerabilitiesSortOrderEnum
func GetListVulnerabilitiesSortOrderEnumStringValues() []string {
	return []string{
		"ASC",
		"DESC",
	}
}

// GetMappingListVulnerabilitiesSortOrderEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListVulnerabilitiesSortOrderEnum(val string) (ListVulnerabilitiesSortOrderEnum, bool) {
	enum, ok := mappingListVulnerabilitiesSortOrderEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListVulnerabilitiesSortByEnum Enum with underlying type: string
type ListVulnerabilitiesSortByEnum string

// Set of constants representing the allowable values for ListVulnerabilitiesSortByEnum
const (
	ListVulnerabilitiesSortByName               ListVulnerabilitiesSortByEnum = "name"
	ListVulnerabilitiesSortBySeverity           ListVulnerabilitiesSortByEnum = "severity"
	ListVulnerabilitiesSortByFirstdetected      ListVulnerabilitiesSortByEnum = "firstDetected"
	ListVulnerabilitiesSortByLastdetected       ListVulnerabilitiesSortByEnum = "lastDetected"
	ListVulnerabilitiesSortByImpactedhosts      ListVulnerabilitiesSortByEnum = "impactedHosts"
	ListVulnerabilitiesSortByImpactedcontainers ListVulnerabilitiesSortByEnum = "impactedContainers"
	ListVulnerabilitiesSortByImpactedresources  ListVulnerabilitiesSortByEnum = "impactedResources"
)

var mappingListVulnerabilitiesSortByEnum = map[string]ListVulnerabilitiesSortByEnum{
	"name":               ListVulnerabilitiesSortByName,
	"severity":           ListVulnerabilitiesSortBySeverity,
	"firstDetected":      ListVulnerabilitiesSortByFirstdetected,
	"lastDetected":       ListVulnerabilitiesSortByLastdetected,
	"impactedHosts":      ListVulnerabilitiesSortByImpactedhosts,
	"impactedContainers": ListVulnerabilitiesSortByImpactedcontainers,
	"impactedResources":  ListVulnerabilitiesSortByImpactedresources,
}

var mappingListVulnerabilitiesSortByEnumLowerCase = map[string]ListVulnerabilitiesSortByEnum{
	"name":               ListVulnerabilitiesSortByName,
	"severity":           ListVulnerabilitiesSortBySeverity,
	"firstdetected":      ListVulnerabilitiesSortByFirstdetected,
	"lastdetected":       ListVulnerabilitiesSortByLastdetected,
	"impactedhosts":      ListVulnerabilitiesSortByImpactedhosts,
	"impactedcontainers": ListVulnerabilitiesSortByImpactedcontainers,
	"impactedresources":  ListVulnerabilitiesSortByImpactedresources,
}

// GetListVulnerabilitiesSortByEnumValues Enumerates the set of values for ListVulnerabilitiesSortByEnum
func GetListVulnerabilitiesSortByEnumValues() []ListVulnerabilitiesSortByEnum {
	values := make([]ListVulnerabilitiesSortByEnum, 0)
	for _, v := range mappingListVulnerabilitiesSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetListVulnerabilitiesSortByEnumStringValues Enumerates the set of values in String for ListVulnerabilitiesSortByEnum
func GetListVulnerabilitiesSortByEnumStringValues() []string {
	return []string{
		"name",
		"severity",
		"firstDetected",
		"lastDetected",
		"impactedHosts",
		"impactedContainers",
		"impactedResources",
	}
}

// GetMappingListVulnerabilitiesSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListVulnerabilitiesSortByEnum(val string) (ListVulnerabilitiesSortByEnum, bool) {
	enum, ok := mappingListVulnerabilitiesSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
