// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// ExportHostAgentScanResultCsvDetails Details for a HostAgentScan list export to CSV action
type ExportHostAgentScanResultCsvDetails struct {

	// The OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to list scans in.
	CompartmentId *string `mandatory:"true" json:"compartmentId"`

	// Date and time after which scans were started, as described in RFC 3339 (https://tools.ietf.org/rfc/rfc3339)
	TimeStartedAfter *common.SDKTime `mandatory:"true" json:"timeStartedAfter"`

	// Date and time before which scans were started, as described in RFC 3339 (https://tools.ietf.org/rfc/rfc3339)
	TimeStartedBefore *common.SDKTime `mandatory:"true" json:"timeStartedBefore"`

	// Parameter to filter by highestProblemSeverity for scan results
	HighestProblemSeverity ScanResultProblemSeverityEnum `mandatory:"false" json:"highestProblemSeverity,omitempty"`

	// Parameter to filter by a single compute instance ID for scan results
	InstanceId *string `mandatory:"false" json:"instanceId"`

	// Parameter to filter by operating system for scan results
	OperatingSystem *string `mandatory:"false" json:"operatingSystem"`
}

func (m ExportHostAgentScanResultCsvDetails) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m ExportHostAgentScanResultCsvDetails) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if _, ok := GetMappingScanResultProblemSeverityEnum(string(m.HighestProblemSeverity)); !ok && m.HighestProblemSeverity != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for HighestProblemSeverity: %s. Supported values are: %s.", m.HighestProblemSeverity, strings.Join(GetScanResultProblemSeverityEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
