// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// LogAnalytics API
//
// The LogAnalytics API for the LogAnalytics service.
//

package loganalytics

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// Dependency Details of a dependency an object or feature defines on another. For
// example, a source may depend on a parser either directly or indirectly.
type Dependency struct {

	// The dependency type.
	Type *string `mandatory:"false" json:"type"`

	// The type of reference that defines the dependency.
	ReferenceType *string `mandatory:"false" json:"referenceType"`

	// The unique identifier of the reference, if available.
	ReferenceId *int64 `mandatory:"false" json:"referenceId"`
}

func (m Dependency) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m Dependency) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
