// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package fleetappsmanagement

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// ListCompliancePoliciesRequest wrapper for the ListCompliancePolicies operation
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/fleetappsmanagement/ListCompliancePolicies.go.html to see an example of how to use ListCompliancePoliciesRequest.
type ListCompliancePoliciesRequest struct {

	// The ID of the compartment in which to list resources.
	CompartmentId *string `mandatory:"false" contributesTo:"query" name:"compartmentId"`

	// A filter to return only resources that match the given lifecycle state. The
	// state value is case-insensitive.
	LifecycleState CompliancePolicyLifecycleStateEnum `mandatory:"false" contributesTo:"query" name:"lifecycleState" omitEmpty:"true"`

	// A filter to return only resources that match the entire display name given.
	DisplayName *string `mandatory:"false" contributesTo:"query" name:"displayName"`

	// unique CompliancePolicy identifier.
	Id *string `mandatory:"false" contributesTo:"query" name:"id"`

	// The maximum number of items to return.
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// The sort order to use, either 'ASC' or 'DESC'.
	SortOrder ListCompliancePoliciesSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.
	SortBy ListCompliancePoliciesSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// The client request ID for tracing.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListCompliancePoliciesRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListCompliancePoliciesRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request ListCompliancePoliciesRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListCompliancePoliciesRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request ListCompliancePoliciesRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingCompliancePolicyLifecycleStateEnum(string(request.LifecycleState)); !ok && request.LifecycleState != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for LifecycleState: %s. Supported values are: %s.", request.LifecycleState, strings.Join(GetCompliancePolicyLifecycleStateEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListCompliancePoliciesSortOrderEnum(string(request.SortOrder)); !ok && request.SortOrder != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortOrder: %s. Supported values are: %s.", request.SortOrder, strings.Join(GetListCompliancePoliciesSortOrderEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListCompliancePoliciesSortByEnum(string(request.SortBy)); !ok && request.SortBy != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortBy: %s. Supported values are: %s.", request.SortBy, strings.Join(GetListCompliancePoliciesSortByEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ListCompliancePoliciesResponse wrapper for the ListCompliancePolicies operation
type ListCompliancePoliciesResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of CompliancePolicyCollection instances
	CompliancePolicyCollection `presentIn:"body"`

	// Unique Oracle-assigned identifier for the request. If you need to contact
	// Oracle about a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`

	// For pagination of a list of items. When paging through a list, if this header appears in the response,
	// then a partial list might have been returned. Include this value as the `page` parameter for the
	// subsequent GET request to get the next batch of items.
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`
}

func (response ListCompliancePoliciesResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListCompliancePoliciesResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListCompliancePoliciesSortOrderEnum Enum with underlying type: string
type ListCompliancePoliciesSortOrderEnum string

// Set of constants representing the allowable values for ListCompliancePoliciesSortOrderEnum
const (
	ListCompliancePoliciesSortOrderAsc  ListCompliancePoliciesSortOrderEnum = "ASC"
	ListCompliancePoliciesSortOrderDesc ListCompliancePoliciesSortOrderEnum = "DESC"
)

var mappingListCompliancePoliciesSortOrderEnum = map[string]ListCompliancePoliciesSortOrderEnum{
	"ASC":  ListCompliancePoliciesSortOrderAsc,
	"DESC": ListCompliancePoliciesSortOrderDesc,
}

var mappingListCompliancePoliciesSortOrderEnumLowerCase = map[string]ListCompliancePoliciesSortOrderEnum{
	"asc":  ListCompliancePoliciesSortOrderAsc,
	"desc": ListCompliancePoliciesSortOrderDesc,
}

// GetListCompliancePoliciesSortOrderEnumValues Enumerates the set of values for ListCompliancePoliciesSortOrderEnum
func GetListCompliancePoliciesSortOrderEnumValues() []ListCompliancePoliciesSortOrderEnum {
	values := make([]ListCompliancePoliciesSortOrderEnum, 0)
	for _, v := range mappingListCompliancePoliciesSortOrderEnum {
		values = append(values, v)
	}
	return values
}

// GetListCompliancePoliciesSortOrderEnumStringValues Enumerates the set of values in String for ListCompliancePoliciesSortOrderEnum
func GetListCompliancePoliciesSortOrderEnumStringValues() []string {
	return []string{
		"ASC",
		"DESC",
	}
}

// GetMappingListCompliancePoliciesSortOrderEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListCompliancePoliciesSortOrderEnum(val string) (ListCompliancePoliciesSortOrderEnum, bool) {
	enum, ok := mappingListCompliancePoliciesSortOrderEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListCompliancePoliciesSortByEnum Enum with underlying type: string
type ListCompliancePoliciesSortByEnum string

// Set of constants representing the allowable values for ListCompliancePoliciesSortByEnum
const (
	ListCompliancePoliciesSortByTimecreated ListCompliancePoliciesSortByEnum = "timeCreated"
	ListCompliancePoliciesSortByDisplayname ListCompliancePoliciesSortByEnum = "displayName"
)

var mappingListCompliancePoliciesSortByEnum = map[string]ListCompliancePoliciesSortByEnum{
	"timeCreated": ListCompliancePoliciesSortByTimecreated,
	"displayName": ListCompliancePoliciesSortByDisplayname,
}

var mappingListCompliancePoliciesSortByEnumLowerCase = map[string]ListCompliancePoliciesSortByEnum{
	"timecreated": ListCompliancePoliciesSortByTimecreated,
	"displayname": ListCompliancePoliciesSortByDisplayname,
}

// GetListCompliancePoliciesSortByEnumValues Enumerates the set of values for ListCompliancePoliciesSortByEnum
func GetListCompliancePoliciesSortByEnumValues() []ListCompliancePoliciesSortByEnum {
	values := make([]ListCompliancePoliciesSortByEnum, 0)
	for _, v := range mappingListCompliancePoliciesSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetListCompliancePoliciesSortByEnumStringValues Enumerates the set of values in String for ListCompliancePoliciesSortByEnum
func GetListCompliancePoliciesSortByEnumStringValues() []string {
	return []string{
		"timeCreated",
		"displayName",
	}
}

// GetMappingListCompliancePoliciesSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListCompliancePoliciesSortByEnum(val string) (ListCompliancePoliciesSortByEnum, bool) {
	enum, ok := mappingListCompliancePoliciesSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
