// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Application Dependency Management API
//
// Use the Application Dependency Management API to create knowledge bases and vulnerability audits.  For more information, see ADM (https://docs.oracle.com/iaas/Content/application-dependency-management/home.htm).
//

package adm

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// Vulnerability A vulnerability is a weakness or error in an artifact.
// A vulnerability is a generalization of a CVE (every CVE is a vulnerability, but not every vulnerability has a CVE).
type Vulnerability struct {

	// Unique vulnerability identifier, e.g. CVE-1999-0067.
	Id *string `mandatory:"true" json:"id"`

	// Indicates if the vulnerability was ignored according to the audit configuration.
	IsIgnored *bool `mandatory:"true" json:"isIgnored"`

	// Source that published the vulnerability
	Source *string `mandatory:"false" json:"source"`

	// Common Vulnerability Scoring System (CVSS) Version 2.
	CvssV2Score *float32 `mandatory:"false" json:"cvssV2Score"`

	// Common Vulnerability Scoring System (CVSS) Version 3.
	CvssV3Score *float32 `mandatory:"false" json:"cvssV3Score"`

	// ADM qualitative severity score. Can be either NONE, LOW, MEDIUM, HIGH or CRITICAL.
	Severity VulnerabilitySeverityEnum `mandatory:"false" json:"severity,omitempty"`

	// Indicates if the vulnerability is a false positive according to the usage data. If no usage data was provided or the service cannot infer usage of the vulnerable code then this property is `null`.
	IsFalsePositive *bool `mandatory:"false" json:"isFalsePositive"`
}

func (m Vulnerability) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m Vulnerability) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if _, ok := GetMappingVulnerabilitySeverityEnum(string(m.Severity)); !ok && m.Severity != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for Severity: %s. Supported values are: %s.", m.Severity, strings.Join(GetVulnerabilitySeverityEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
