// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Application Dependency Management API
//
// Use the Application Dependency Management API to create knowledge bases and vulnerability audits.  For more information, see ADM (https://docs.oracle.com/iaas/Content/application-dependency-management/home.htm).
//

package adm

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// ApplicationDependency An application dependency resource creates a vulnerability audit.
type ApplicationDependency struct {

	// Unique identifier of an application dependency, for example nodeId1.
	// The nodeId can be generated by assigning a unique id to each application dependency
	// in the tree of application dependencies.
	// Every node, even those who share the same GAV, should have a different nodeId.
	// The preferred way of constructing a nodeId is to assign incremental integers
	// during a breadth first or depth first search.
	// A nodeId can be reused only it refers to the same subtree of application dependencies.
	// (This is not equivalent to referring to the same GAV, that is,
	// a GAV can have multiple transitive dependencies.)
	NodeId *string `mandatory:"true" json:"nodeId"`

	// Group Artifact Version (GAV) identifier (Group:Artifact:Version). Example: org.graalvm.nativeimage:svm:21.1.0.
	// "N/A" for non-maven artifacts.
	Gav *string `mandatory:"false" json:"gav"`

	// Package URL defined in https://github.com/package-url/purl-spec, e.g. pkg:maven/org.graalvm.nativeimage/svm@21.1.0
	Purl *string `mandatory:"false" json:"purl"`

	// List of application dependencies on which this application dependency depends, each identified by its nodeId.
	ApplicationDependencyNodeIds []string `mandatory:"false" json:"applicationDependencyNodeIds"`
}

func (m ApplicationDependency) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m ApplicationDependency) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
