package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ProbeAccessPointNetworkQuality invokes the smartag.ProbeAccessPointNetworkQuality API synchronously
func (client *Client) ProbeAccessPointNetworkQuality(request *ProbeAccessPointNetworkQualityRequest) (response *ProbeAccessPointNetworkQualityResponse, err error) {
	response = CreateProbeAccessPointNetworkQualityResponse()
	err = client.DoAction(request, response)
	return
}

// ProbeAccessPointNetworkQualityWithChan invokes the smartag.ProbeAccessPointNetworkQuality API asynchronously
func (client *Client) ProbeAccessPointNetworkQualityWithChan(request *ProbeAccessPointNetworkQualityRequest) (<-chan *ProbeAccessPointNetworkQualityResponse, <-chan error) {
	responseChan := make(chan *ProbeAccessPointNetworkQualityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ProbeAccessPointNetworkQuality(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ProbeAccessPointNetworkQualityWithCallback invokes the smartag.ProbeAccessPointNetworkQuality API asynchronously
func (client *Client) ProbeAccessPointNetworkQualityWithCallback(request *ProbeAccessPointNetworkQualityRequest, callback func(response *ProbeAccessPointNetworkQualityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ProbeAccessPointNetworkQualityResponse
		var err error
		defer close(result)
		response, err = client.ProbeAccessPointNetworkQuality(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ProbeAccessPointNetworkQualityRequest is the request struct for api ProbeAccessPointNetworkQuality
type ProbeAccessPointNetworkQualityRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	AccessPointIds       *[]string        `position:"Query" name:"AccessPointIds"  type:"Repeated"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
}

// ProbeAccessPointNetworkQualityResponse is the response struct for api ProbeAccessPointNetworkQuality
type ProbeAccessPointNetworkQualityResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateProbeAccessPointNetworkQualityRequest creates a request to invoke ProbeAccessPointNetworkQuality API
func CreateProbeAccessPointNetworkQualityRequest() (request *ProbeAccessPointNetworkQualityRequest) {
	request = &ProbeAccessPointNetworkQualityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "ProbeAccessPointNetworkQuality", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateProbeAccessPointNetworkQualityResponse creates a response to parse from ProbeAccessPointNetworkQuality response
func CreateProbeAccessPointNetworkQualityResponse() (response *ProbeAccessPointNetworkQualityResponse) {
	response = &ProbeAccessPointNetworkQualityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
