package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListChatbotInstances invokes the outboundbot.ListChatbotInstances API synchronously
func (client *Client) ListChatbotInstances(request *ListChatbotInstancesRequest) (response *ListChatbotInstancesResponse, err error) {
	response = CreateListChatbotInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// ListChatbotInstancesWithChan invokes the outboundbot.ListChatbotInstances API asynchronously
func (client *Client) ListChatbotInstancesWithChan(request *ListChatbotInstancesRequest) (<-chan *ListChatbotInstancesResponse, <-chan error) {
	responseChan := make(chan *ListChatbotInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListChatbotInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListChatbotInstancesWithCallback invokes the outboundbot.ListChatbotInstances API asynchronously
func (client *Client) ListChatbotInstancesWithCallback(request *ListChatbotInstancesRequest, callback func(response *ListChatbotInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListChatbotInstancesResponse
		var err error
		defer close(result)
		response, err = client.ListChatbotInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListChatbotInstancesRequest is the request struct for api ListChatbotInstances
type ListChatbotInstancesRequest struct {
	*requests.RpcRequest
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
}

// ListChatbotInstancesResponse is the response struct for api ListChatbotInstances
type ListChatbotInstancesResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	PageSize       int64  `json:"PageSize" xml:"PageSize"`
	PageNumber     int64  `json:"PageNumber" xml:"PageNumber"`
	TotalCount     int64  `json:"TotalCount" xml:"TotalCount"`
	Bots           []Bot  `json:"Bots" xml:"Bots"`
}

// CreateListChatbotInstancesRequest creates a request to invoke ListChatbotInstances API
func CreateListChatbotInstancesRequest() (request *ListChatbotInstancesRequest) {
	request = &ListChatbotInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "ListChatbotInstances", "outboundbot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListChatbotInstancesResponse creates a response to parse from ListChatbotInstances response
func CreateListChatbotInstancesResponse() (response *ListChatbotInstancesResponse) {
	response = &ListChatbotInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
