package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateNacosInstance invokes the mse.CreateNacosInstance API synchronously
func (client *Client) CreateNacosInstance(request *CreateNacosInstanceRequest) (response *CreateNacosInstanceResponse, err error) {
	response = CreateCreateNacosInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateNacosInstanceWithChan invokes the mse.CreateNacosInstance API asynchronously
func (client *Client) CreateNacosInstanceWithChan(request *CreateNacosInstanceRequest) (<-chan *CreateNacosInstanceResponse, <-chan error) {
	responseChan := make(chan *CreateNacosInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateNacosInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateNacosInstanceWithCallback invokes the mse.CreateNacosInstance API asynchronously
func (client *Client) CreateNacosInstanceWithCallback(request *CreateNacosInstanceRequest, callback func(response *CreateNacosInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateNacosInstanceResponse
		var err error
		defer close(result)
		response, err = client.CreateNacosInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateNacosInstanceRequest is the request struct for api CreateNacosInstance
type CreateNacosInstanceRequest struct {
	*requests.RpcRequest
	Metadata       string           `position:"Body" name:"Metadata"`
	ClusterName    string           `position:"Query" name:"ClusterName"`
	Ephemeral      requests.Boolean `position:"Query" name:"Ephemeral"`
	Enabled        requests.Boolean `position:"Query" name:"Enabled"`
	NamespaceId    string           `position:"Query" name:"NamespaceId"`
	ServiceName    string           `position:"Query" name:"ServiceName"`
	Ip             string           `position:"Query" name:"Ip"`
	Weight         string           `position:"Query" name:"Weight"`
	GroupName      string           `position:"Query" name:"GroupName"`
	InstanceId     string           `position:"Query" name:"InstanceId"`
	Port           requests.Integer `position:"Query" name:"Port"`
	AcceptLanguage string           `position:"Query" name:"AcceptLanguage"`
}

// CreateNacosInstanceResponse is the response struct for api CreateNacosInstance
type CreateNacosInstanceResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Message        string `json:"Message" xml:"Message"`
	Code           int    `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           string `json:"Data" xml:"Data"`
}

// CreateCreateNacosInstanceRequest creates a request to invoke CreateNacosInstance API
func CreateCreateNacosInstanceRequest() (request *CreateNacosInstanceRequest) {
	request = &CreateNacosInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "CreateNacosInstance", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateNacosInstanceResponse creates a response to parse from CreateNacosInstance response
func CreateCreateNacosInstanceResponse() (response *CreateNacosInstanceResponse) {
	response = &CreateNacosInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
