package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListApDetailInfo invokes the cloudwf.ListApDetailInfo API synchronously
// api document: https://help.aliyun.com/api/cloudwf/listapdetailinfo.html
func (client *Client) ListApDetailInfo(request *ListApDetailInfoRequest) (response *ListApDetailInfoResponse, err error) {
	response = CreateListApDetailInfoResponse()
	err = client.DoAction(request, response)
	return
}

// ListApDetailInfoWithChan invokes the cloudwf.ListApDetailInfo API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/listapdetailinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListApDetailInfoWithChan(request *ListApDetailInfoRequest) (<-chan *ListApDetailInfoResponse, <-chan error) {
	responseChan := make(chan *ListApDetailInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListApDetailInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListApDetailInfoWithCallback invokes the cloudwf.ListApDetailInfo API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/listapdetailinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListApDetailInfoWithCallback(request *ListApDetailInfoRequest, callback func(response *ListApDetailInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListApDetailInfoResponse
		var err error
		defer close(result)
		response, err = client.ListApDetailInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListApDetailInfoRequest is the request struct for api ListApDetailInfo
type ListApDetailInfoRequest struct {
	*requests.RpcRequest
	ApAssetId requests.Integer `position:"Query" name:"ApAssetId"`
}

// ListApDetailInfoResponse is the response struct for api ListApDetailInfo
type ListApDetailInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateListApDetailInfoRequest creates a request to invoke ListApDetailInfo API
func CreateListApDetailInfoRequest() (request *ListApDetailInfoRequest) {
	request = &ListApDetailInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ListApDetailInfo", "cloudwf", "openAPI")
	return
}

// CreateListApDetailInfoResponse creates a response to parse from ListApDetailInfo response
func CreateListApDetailInfoResponse() (response *ListApDetailInfoResponse) {
	response = &ListApDetailInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
