// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Terraform Plugin RPC protocol version 6.8
//
// This file defines version 6.8 of the RPC protocol. To implement a plugin
// against this protocol, copy this definition into your own codebase and
// use protoc to generate stubs for your target language.
//
// This file will not be updated. Any minor versions of protocol 6 to follow
// should copy this file and modify the copy while maintaing backwards
// compatibility. Breaking changes, if any are required, will come
// in a subsequent major version with its own separate proto definition.
//
// Note that only the proto files included in a release tag of Terraform are
// official protocol releases. Proto files taken from other commits may include
// incomplete changes or features that did not make it into a final release.
// In all reasonable cases, plugin developers should take the proto file from
// the tag of the most recent release of Terraform, and not from the main
// branch or any other development branch.
//

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v5.29.3
// source: tfplugin6.proto

package tfplugin6

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	Provider_GetMetadata_FullMethodName                     = "/tfplugin6.Provider/GetMetadata"
	Provider_GetProviderSchema_FullMethodName               = "/tfplugin6.Provider/GetProviderSchema"
	Provider_ValidateProviderConfig_FullMethodName          = "/tfplugin6.Provider/ValidateProviderConfig"
	Provider_ValidateResourceConfig_FullMethodName          = "/tfplugin6.Provider/ValidateResourceConfig"
	Provider_ValidateDataResourceConfig_FullMethodName      = "/tfplugin6.Provider/ValidateDataResourceConfig"
	Provider_UpgradeResourceState_FullMethodName            = "/tfplugin6.Provider/UpgradeResourceState"
	Provider_ConfigureProvider_FullMethodName               = "/tfplugin6.Provider/ConfigureProvider"
	Provider_ReadResource_FullMethodName                    = "/tfplugin6.Provider/ReadResource"
	Provider_PlanResourceChange_FullMethodName              = "/tfplugin6.Provider/PlanResourceChange"
	Provider_ApplyResourceChange_FullMethodName             = "/tfplugin6.Provider/ApplyResourceChange"
	Provider_ImportResourceState_FullMethodName             = "/tfplugin6.Provider/ImportResourceState"
	Provider_MoveResourceState_FullMethodName               = "/tfplugin6.Provider/MoveResourceState"
	Provider_ReadDataSource_FullMethodName                  = "/tfplugin6.Provider/ReadDataSource"
	Provider_ValidateEphemeralResourceConfig_FullMethodName = "/tfplugin6.Provider/ValidateEphemeralResourceConfig"
	Provider_OpenEphemeralResource_FullMethodName           = "/tfplugin6.Provider/OpenEphemeralResource"
	Provider_RenewEphemeralResource_FullMethodName          = "/tfplugin6.Provider/RenewEphemeralResource"
	Provider_CloseEphemeralResource_FullMethodName          = "/tfplugin6.Provider/CloseEphemeralResource"
	Provider_GetFunctions_FullMethodName                    = "/tfplugin6.Provider/GetFunctions"
	Provider_CallFunction_FullMethodName                    = "/tfplugin6.Provider/CallFunction"
	Provider_StopProvider_FullMethodName                    = "/tfplugin6.Provider/StopProvider"
)

// ProviderClient is the client API for Provider service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ProviderClient interface {
	// GetMetadata returns upfront information about server capabilities and
	// supported resource types without requiring the server to instantiate all
	// schema information, which may be memory intensive. This RPC is optional,
	// where clients may receive an unimplemented RPC error. Clients should
	// ignore the error and call the GetProviderSchema RPC as a fallback.
	GetMetadata(ctx context.Context, in *GetMetadata_Request, opts ...grpc.CallOption) (*GetMetadata_Response, error)
	// GetSchema returns schema information for the provider, data resources,
	// and managed resources.
	GetProviderSchema(ctx context.Context, in *GetProviderSchema_Request, opts ...grpc.CallOption) (*GetProviderSchema_Response, error)
	ValidateProviderConfig(ctx context.Context, in *ValidateProviderConfig_Request, opts ...grpc.CallOption) (*ValidateProviderConfig_Response, error)
	ValidateResourceConfig(ctx context.Context, in *ValidateResourceConfig_Request, opts ...grpc.CallOption) (*ValidateResourceConfig_Response, error)
	ValidateDataResourceConfig(ctx context.Context, in *ValidateDataResourceConfig_Request, opts ...grpc.CallOption) (*ValidateDataResourceConfig_Response, error)
	UpgradeResourceState(ctx context.Context, in *UpgradeResourceState_Request, opts ...grpc.CallOption) (*UpgradeResourceState_Response, error)
	// ////// One-time initialization, called before other functions below
	ConfigureProvider(ctx context.Context, in *ConfigureProvider_Request, opts ...grpc.CallOption) (*ConfigureProvider_Response, error)
	// ////// Managed Resource Lifecycle
	ReadResource(ctx context.Context, in *ReadResource_Request, opts ...grpc.CallOption) (*ReadResource_Response, error)
	PlanResourceChange(ctx context.Context, in *PlanResourceChange_Request, opts ...grpc.CallOption) (*PlanResourceChange_Response, error)
	ApplyResourceChange(ctx context.Context, in *ApplyResourceChange_Request, opts ...grpc.CallOption) (*ApplyResourceChange_Response, error)
	ImportResourceState(ctx context.Context, in *ImportResourceState_Request, opts ...grpc.CallOption) (*ImportResourceState_Response, error)
	MoveResourceState(ctx context.Context, in *MoveResourceState_Request, opts ...grpc.CallOption) (*MoveResourceState_Response, error)
	ReadDataSource(ctx context.Context, in *ReadDataSource_Request, opts ...grpc.CallOption) (*ReadDataSource_Response, error)
	// ////// Ephemeral Resource Lifecycle
	ValidateEphemeralResourceConfig(ctx context.Context, in *ValidateEphemeralResourceConfig_Request, opts ...grpc.CallOption) (*ValidateEphemeralResourceConfig_Response, error)
	OpenEphemeralResource(ctx context.Context, in *OpenEphemeralResource_Request, opts ...grpc.CallOption) (*OpenEphemeralResource_Response, error)
	RenewEphemeralResource(ctx context.Context, in *RenewEphemeralResource_Request, opts ...grpc.CallOption) (*RenewEphemeralResource_Response, error)
	CloseEphemeralResource(ctx context.Context, in *CloseEphemeralResource_Request, opts ...grpc.CallOption) (*CloseEphemeralResource_Response, error)
	// GetFunctions returns the definitions of all functions.
	GetFunctions(ctx context.Context, in *GetFunctions_Request, opts ...grpc.CallOption) (*GetFunctions_Response, error)
	// CallFunction runs the provider-defined function logic and returns
	// the result with any diagnostics.
	CallFunction(ctx context.Context, in *CallFunction_Request, opts ...grpc.CallOption) (*CallFunction_Response, error)
	// ////// Graceful Shutdown
	StopProvider(ctx context.Context, in *StopProvider_Request, opts ...grpc.CallOption) (*StopProvider_Response, error)
}

type providerClient struct {
	cc grpc.ClientConnInterface
}

func NewProviderClient(cc grpc.ClientConnInterface) ProviderClient {
	return &providerClient{cc}
}

func (c *providerClient) GetMetadata(ctx context.Context, in *GetMetadata_Request, opts ...grpc.CallOption) (*GetMetadata_Response, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetMetadata_Response)
	err := c.cc.Invoke(ctx, Provider_GetMetadata_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) GetProviderSchema(ctx context.Context, in *GetProviderSchema_Request, opts ...grpc.CallOption) (*GetProviderSchema_Response, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetProviderSchema_Response)
	err := c.cc.Invoke(ctx, Provider_GetProviderSchema_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) ValidateProviderConfig(ctx context.Context, in *ValidateProviderConfig_Request, opts ...grpc.CallOption) (*ValidateProviderConfig_Response, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ValidateProviderConfig_Response)
	err := c.cc.Invoke(ctx, Provider_ValidateProviderConfig_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) ValidateResourceConfig(ctx context.Context, in *ValidateResourceConfig_Request, opts ...grpc.CallOption) (*ValidateResourceConfig_Response, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ValidateResourceConfig_Response)
	err := c.cc.Invoke(ctx, Provider_ValidateResourceConfig_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) ValidateDataResourceConfig(ctx context.Context, in *ValidateDataResourceConfig_Request, opts ...grpc.CallOption) (*ValidateDataResourceConfig_Response, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ValidateDataResourceConfig_Response)
	err := c.cc.Invoke(ctx, Provider_ValidateDataResourceConfig_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) UpgradeResourceState(ctx context.Context, in *UpgradeResourceState_Request, opts ...grpc.CallOption) (*UpgradeResourceState_Response, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(UpgradeResourceState_Response)
	err := c.cc.Invoke(ctx, Provider_UpgradeResourceState_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) ConfigureProvider(ctx context.Context, in *ConfigureProvider_Request, opts ...grpc.CallOption) (*ConfigureProvider_Response, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ConfigureProvider_Response)
	err := c.cc.Invoke(ctx, Provider_ConfigureProvider_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) ReadResource(ctx context.Context, in *ReadResource_Request, opts ...grpc.CallOption) (*ReadResource_Response, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ReadResource_Response)
	err := c.cc.Invoke(ctx, Provider_ReadResource_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) PlanResourceChange(ctx context.Context, in *PlanResourceChange_Request, opts ...grpc.CallOption) (*PlanResourceChange_Response, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(PlanResourceChange_Response)
	err := c.cc.Invoke(ctx, Provider_PlanResourceChange_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) ApplyResourceChange(ctx context.Context, in *ApplyResourceChange_Request, opts ...grpc.CallOption) (*ApplyResourceChange_Response, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ApplyResourceChange_Response)
	err := c.cc.Invoke(ctx, Provider_ApplyResourceChange_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) ImportResourceState(ctx context.Context, in *ImportResourceState_Request, opts ...grpc.CallOption) (*ImportResourceState_Response, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ImportResourceState_Response)
	err := c.cc.Invoke(ctx, Provider_ImportResourceState_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) MoveResourceState(ctx context.Context, in *MoveResourceState_Request, opts ...grpc.CallOption) (*MoveResourceState_Response, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(MoveResourceState_Response)
	err := c.cc.Invoke(ctx, Provider_MoveResourceState_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) ReadDataSource(ctx context.Context, in *ReadDataSource_Request, opts ...grpc.CallOption) (*ReadDataSource_Response, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ReadDataSource_Response)
	err := c.cc.Invoke(ctx, Provider_ReadDataSource_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) ValidateEphemeralResourceConfig(ctx context.Context, in *ValidateEphemeralResourceConfig_Request, opts ...grpc.CallOption) (*ValidateEphemeralResourceConfig_Response, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ValidateEphemeralResourceConfig_Response)
	err := c.cc.Invoke(ctx, Provider_ValidateEphemeralResourceConfig_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) OpenEphemeralResource(ctx context.Context, in *OpenEphemeralResource_Request, opts ...grpc.CallOption) (*OpenEphemeralResource_Response, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(OpenEphemeralResource_Response)
	err := c.cc.Invoke(ctx, Provider_OpenEphemeralResource_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) RenewEphemeralResource(ctx context.Context, in *RenewEphemeralResource_Request, opts ...grpc.CallOption) (*RenewEphemeralResource_Response, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(RenewEphemeralResource_Response)
	err := c.cc.Invoke(ctx, Provider_RenewEphemeralResource_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) CloseEphemeralResource(ctx context.Context, in *CloseEphemeralResource_Request, opts ...grpc.CallOption) (*CloseEphemeralResource_Response, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(CloseEphemeralResource_Response)
	err := c.cc.Invoke(ctx, Provider_CloseEphemeralResource_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) GetFunctions(ctx context.Context, in *GetFunctions_Request, opts ...grpc.CallOption) (*GetFunctions_Response, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetFunctions_Response)
	err := c.cc.Invoke(ctx, Provider_GetFunctions_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) CallFunction(ctx context.Context, in *CallFunction_Request, opts ...grpc.CallOption) (*CallFunction_Response, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(CallFunction_Response)
	err := c.cc.Invoke(ctx, Provider_CallFunction_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) StopProvider(ctx context.Context, in *StopProvider_Request, opts ...grpc.CallOption) (*StopProvider_Response, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(StopProvider_Response)
	err := c.cc.Invoke(ctx, Provider_StopProvider_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ProviderServer is the server API for Provider service.
// All implementations must embed UnimplementedProviderServer
// for forward compatibility.
type ProviderServer interface {
	// GetMetadata returns upfront information about server capabilities and
	// supported resource types without requiring the server to instantiate all
	// schema information, which may be memory intensive. This RPC is optional,
	// where clients may receive an unimplemented RPC error. Clients should
	// ignore the error and call the GetProviderSchema RPC as a fallback.
	GetMetadata(context.Context, *GetMetadata_Request) (*GetMetadata_Response, error)
	// GetSchema returns schema information for the provider, data resources,
	// and managed resources.
	GetProviderSchema(context.Context, *GetProviderSchema_Request) (*GetProviderSchema_Response, error)
	ValidateProviderConfig(context.Context, *ValidateProviderConfig_Request) (*ValidateProviderConfig_Response, error)
	ValidateResourceConfig(context.Context, *ValidateResourceConfig_Request) (*ValidateResourceConfig_Response, error)
	ValidateDataResourceConfig(context.Context, *ValidateDataResourceConfig_Request) (*ValidateDataResourceConfig_Response, error)
	UpgradeResourceState(context.Context, *UpgradeResourceState_Request) (*UpgradeResourceState_Response, error)
	// ////// One-time initialization, called before other functions below
	ConfigureProvider(context.Context, *ConfigureProvider_Request) (*ConfigureProvider_Response, error)
	// ////// Managed Resource Lifecycle
	ReadResource(context.Context, *ReadResource_Request) (*ReadResource_Response, error)
	PlanResourceChange(context.Context, *PlanResourceChange_Request) (*PlanResourceChange_Response, error)
	ApplyResourceChange(context.Context, *ApplyResourceChange_Request) (*ApplyResourceChange_Response, error)
	ImportResourceState(context.Context, *ImportResourceState_Request) (*ImportResourceState_Response, error)
	MoveResourceState(context.Context, *MoveResourceState_Request) (*MoveResourceState_Response, error)
	ReadDataSource(context.Context, *ReadDataSource_Request) (*ReadDataSource_Response, error)
	// ////// Ephemeral Resource Lifecycle
	ValidateEphemeralResourceConfig(context.Context, *ValidateEphemeralResourceConfig_Request) (*ValidateEphemeralResourceConfig_Response, error)
	OpenEphemeralResource(context.Context, *OpenEphemeralResource_Request) (*OpenEphemeralResource_Response, error)
	RenewEphemeralResource(context.Context, *RenewEphemeralResource_Request) (*RenewEphemeralResource_Response, error)
	CloseEphemeralResource(context.Context, *CloseEphemeralResource_Request) (*CloseEphemeralResource_Response, error)
	// GetFunctions returns the definitions of all functions.
	GetFunctions(context.Context, *GetFunctions_Request) (*GetFunctions_Response, error)
	// CallFunction runs the provider-defined function logic and returns
	// the result with any diagnostics.
	CallFunction(context.Context, *CallFunction_Request) (*CallFunction_Response, error)
	// ////// Graceful Shutdown
	StopProvider(context.Context, *StopProvider_Request) (*StopProvider_Response, error)
	mustEmbedUnimplementedProviderServer()
}

// UnimplementedProviderServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedProviderServer struct{}

func (UnimplementedProviderServer) GetMetadata(context.Context, *GetMetadata_Request) (*GetMetadata_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMetadata not implemented")
}
func (UnimplementedProviderServer) GetProviderSchema(context.Context, *GetProviderSchema_Request) (*GetProviderSchema_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProviderSchema not implemented")
}
func (UnimplementedProviderServer) ValidateProviderConfig(context.Context, *ValidateProviderConfig_Request) (*ValidateProviderConfig_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateProviderConfig not implemented")
}
func (UnimplementedProviderServer) ValidateResourceConfig(context.Context, *ValidateResourceConfig_Request) (*ValidateResourceConfig_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateResourceConfig not implemented")
}
func (UnimplementedProviderServer) ValidateDataResourceConfig(context.Context, *ValidateDataResourceConfig_Request) (*ValidateDataResourceConfig_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateDataResourceConfig not implemented")
}
func (UnimplementedProviderServer) UpgradeResourceState(context.Context, *UpgradeResourceState_Request) (*UpgradeResourceState_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpgradeResourceState not implemented")
}
func (UnimplementedProviderServer) ConfigureProvider(context.Context, *ConfigureProvider_Request) (*ConfigureProvider_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConfigureProvider not implemented")
}
func (UnimplementedProviderServer) ReadResource(context.Context, *ReadResource_Request) (*ReadResource_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReadResource not implemented")
}
func (UnimplementedProviderServer) PlanResourceChange(context.Context, *PlanResourceChange_Request) (*PlanResourceChange_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PlanResourceChange not implemented")
}
func (UnimplementedProviderServer) ApplyResourceChange(context.Context, *ApplyResourceChange_Request) (*ApplyResourceChange_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ApplyResourceChange not implemented")
}
func (UnimplementedProviderServer) ImportResourceState(context.Context, *ImportResourceState_Request) (*ImportResourceState_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportResourceState not implemented")
}
func (UnimplementedProviderServer) MoveResourceState(context.Context, *MoveResourceState_Request) (*MoveResourceState_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MoveResourceState not implemented")
}
func (UnimplementedProviderServer) ReadDataSource(context.Context, *ReadDataSource_Request) (*ReadDataSource_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReadDataSource not implemented")
}
func (UnimplementedProviderServer) ValidateEphemeralResourceConfig(context.Context, *ValidateEphemeralResourceConfig_Request) (*ValidateEphemeralResourceConfig_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateEphemeralResourceConfig not implemented")
}
func (UnimplementedProviderServer) OpenEphemeralResource(context.Context, *OpenEphemeralResource_Request) (*OpenEphemeralResource_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method OpenEphemeralResource not implemented")
}
func (UnimplementedProviderServer) RenewEphemeralResource(context.Context, *RenewEphemeralResource_Request) (*RenewEphemeralResource_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RenewEphemeralResource not implemented")
}
func (UnimplementedProviderServer) CloseEphemeralResource(context.Context, *CloseEphemeralResource_Request) (*CloseEphemeralResource_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CloseEphemeralResource not implemented")
}
func (UnimplementedProviderServer) GetFunctions(context.Context, *GetFunctions_Request) (*GetFunctions_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFunctions not implemented")
}
func (UnimplementedProviderServer) CallFunction(context.Context, *CallFunction_Request) (*CallFunction_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CallFunction not implemented")
}
func (UnimplementedProviderServer) StopProvider(context.Context, *StopProvider_Request) (*StopProvider_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopProvider not implemented")
}
func (UnimplementedProviderServer) mustEmbedUnimplementedProviderServer() {}
func (UnimplementedProviderServer) testEmbeddedByValue()                  {}

// UnsafeProviderServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ProviderServer will
// result in compilation errors.
type UnsafeProviderServer interface {
	mustEmbedUnimplementedProviderServer()
}

func RegisterProviderServer(s grpc.ServiceRegistrar, srv ProviderServer) {
	// If the following call pancis, it indicates UnimplementedProviderServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&Provider_ServiceDesc, srv)
}

func _Provider_GetMetadata_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMetadata_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).GetMetadata(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Provider_GetMetadata_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).GetMetadata(ctx, req.(*GetMetadata_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_GetProviderSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProviderSchema_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).GetProviderSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Provider_GetProviderSchema_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).GetProviderSchema(ctx, req.(*GetProviderSchema_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_ValidateProviderConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateProviderConfig_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ValidateProviderConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Provider_ValidateProviderConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ValidateProviderConfig(ctx, req.(*ValidateProviderConfig_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_ValidateResourceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateResourceConfig_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ValidateResourceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Provider_ValidateResourceConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ValidateResourceConfig(ctx, req.(*ValidateResourceConfig_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_ValidateDataResourceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateDataResourceConfig_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ValidateDataResourceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Provider_ValidateDataResourceConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ValidateDataResourceConfig(ctx, req.(*ValidateDataResourceConfig_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_UpgradeResourceState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpgradeResourceState_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).UpgradeResourceState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Provider_UpgradeResourceState_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).UpgradeResourceState(ctx, req.(*UpgradeResourceState_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_ConfigureProvider_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConfigureProvider_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ConfigureProvider(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Provider_ConfigureProvider_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ConfigureProvider(ctx, req.(*ConfigureProvider_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_ReadResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReadResource_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ReadResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Provider_ReadResource_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ReadResource(ctx, req.(*ReadResource_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_PlanResourceChange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PlanResourceChange_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).PlanResourceChange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Provider_PlanResourceChange_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).PlanResourceChange(ctx, req.(*PlanResourceChange_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_ApplyResourceChange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplyResourceChange_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ApplyResourceChange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Provider_ApplyResourceChange_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ApplyResourceChange(ctx, req.(*ApplyResourceChange_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_ImportResourceState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportResourceState_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ImportResourceState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Provider_ImportResourceState_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ImportResourceState(ctx, req.(*ImportResourceState_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_MoveResourceState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveResourceState_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).MoveResourceState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Provider_MoveResourceState_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).MoveResourceState(ctx, req.(*MoveResourceState_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_ReadDataSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReadDataSource_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ReadDataSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Provider_ReadDataSource_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ReadDataSource(ctx, req.(*ReadDataSource_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_ValidateEphemeralResourceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateEphemeralResourceConfig_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ValidateEphemeralResourceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Provider_ValidateEphemeralResourceConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ValidateEphemeralResourceConfig(ctx, req.(*ValidateEphemeralResourceConfig_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_OpenEphemeralResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OpenEphemeralResource_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).OpenEphemeralResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Provider_OpenEphemeralResource_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).OpenEphemeralResource(ctx, req.(*OpenEphemeralResource_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_RenewEphemeralResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RenewEphemeralResource_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).RenewEphemeralResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Provider_RenewEphemeralResource_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).RenewEphemeralResource(ctx, req.(*RenewEphemeralResource_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_CloseEphemeralResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CloseEphemeralResource_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).CloseEphemeralResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Provider_CloseEphemeralResource_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).CloseEphemeralResource(ctx, req.(*CloseEphemeralResource_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_GetFunctions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFunctions_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).GetFunctions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Provider_GetFunctions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).GetFunctions(ctx, req.(*GetFunctions_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_CallFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CallFunction_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).CallFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Provider_CallFunction_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).CallFunction(ctx, req.(*CallFunction_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_StopProvider_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopProvider_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).StopProvider(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Provider_StopProvider_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).StopProvider(ctx, req.(*StopProvider_Request))
	}
	return interceptor(ctx, in, info, handler)
}

// Provider_ServiceDesc is the grpc.ServiceDesc for Provider service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Provider_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "tfplugin6.Provider",
	HandlerType: (*ProviderServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetMetadata",
			Handler:    _Provider_GetMetadata_Handler,
		},
		{
			MethodName: "GetProviderSchema",
			Handler:    _Provider_GetProviderSchema_Handler,
		},
		{
			MethodName: "ValidateProviderConfig",
			Handler:    _Provider_ValidateProviderConfig_Handler,
		},
		{
			MethodName: "ValidateResourceConfig",
			Handler:    _Provider_ValidateResourceConfig_Handler,
		},
		{
			MethodName: "ValidateDataResourceConfig",
			Handler:    _Provider_ValidateDataResourceConfig_Handler,
		},
		{
			MethodName: "UpgradeResourceState",
			Handler:    _Provider_UpgradeResourceState_Handler,
		},
		{
			MethodName: "ConfigureProvider",
			Handler:    _Provider_ConfigureProvider_Handler,
		},
		{
			MethodName: "ReadResource",
			Handler:    _Provider_ReadResource_Handler,
		},
		{
			MethodName: "PlanResourceChange",
			Handler:    _Provider_PlanResourceChange_Handler,
		},
		{
			MethodName: "ApplyResourceChange",
			Handler:    _Provider_ApplyResourceChange_Handler,
		},
		{
			MethodName: "ImportResourceState",
			Handler:    _Provider_ImportResourceState_Handler,
		},
		{
			MethodName: "MoveResourceState",
			Handler:    _Provider_MoveResourceState_Handler,
		},
		{
			MethodName: "ReadDataSource",
			Handler:    _Provider_ReadDataSource_Handler,
		},
		{
			MethodName: "ValidateEphemeralResourceConfig",
			Handler:    _Provider_ValidateEphemeralResourceConfig_Handler,
		},
		{
			MethodName: "OpenEphemeralResource",
			Handler:    _Provider_OpenEphemeralResource_Handler,
		},
		{
			MethodName: "RenewEphemeralResource",
			Handler:    _Provider_RenewEphemeralResource_Handler,
		},
		{
			MethodName: "CloseEphemeralResource",
			Handler:    _Provider_CloseEphemeralResource_Handler,
		},
		{
			MethodName: "GetFunctions",
			Handler:    _Provider_GetFunctions_Handler,
		},
		{
			MethodName: "CallFunction",
			Handler:    _Provider_CallFunction_Handler,
		},
		{
			MethodName: "StopProvider",
			Handler:    _Provider_StopProvider_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "tfplugin6.proto",
}
