// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Terraform Plugin RPC protocol version 6.8
//
// This file defines version 6.8 of the RPC protocol. To implement a plugin
// against this protocol, copy this definition into your own codebase and
// use protoc to generate stubs for your target language.
//
// This file will not be updated. Any minor versions of protocol 6 to follow
// should copy this file and modify the copy while maintaing backwards
// compatibility. Breaking changes, if any are required, will come
// in a subsequent major version with its own separate proto definition.
//
// Note that only the proto files included in a release tag of Terraform are
// official protocol releases. Proto files taken from other commits may include
// incomplete changes or features that did not make it into a final release.
// In all reasonable cases, plugin developers should take the proto file from
// the tag of the most recent release of Terraform, and not from the main
// branch or any other development branch.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.3
// 	protoc        v5.29.3
// source: tfplugin6.proto

package tfplugin6

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type StringKind int32

const (
	StringKind_PLAIN    StringKind = 0
	StringKind_MARKDOWN StringKind = 1
)

// Enum value maps for StringKind.
var (
	StringKind_name = map[int32]string{
		0: "PLAIN",
		1: "MARKDOWN",
	}
	StringKind_value = map[string]int32{
		"PLAIN":    0,
		"MARKDOWN": 1,
	}
)

func (x StringKind) Enum() *StringKind {
	p := new(StringKind)
	*p = x
	return p
}

func (x StringKind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StringKind) Descriptor() protoreflect.EnumDescriptor {
	return file_tfplugin6_proto_enumTypes[0].Descriptor()
}

func (StringKind) Type() protoreflect.EnumType {
	return &file_tfplugin6_proto_enumTypes[0]
}

func (x StringKind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StringKind.Descriptor instead.
func (StringKind) EnumDescriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{0}
}

type Diagnostic_Severity int32

const (
	Diagnostic_INVALID Diagnostic_Severity = 0
	Diagnostic_ERROR   Diagnostic_Severity = 1
	Diagnostic_WARNING Diagnostic_Severity = 2
)

// Enum value maps for Diagnostic_Severity.
var (
	Diagnostic_Severity_name = map[int32]string{
		0: "INVALID",
		1: "ERROR",
		2: "WARNING",
	}
	Diagnostic_Severity_value = map[string]int32{
		"INVALID": 0,
		"ERROR":   1,
		"WARNING": 2,
	}
)

func (x Diagnostic_Severity) Enum() *Diagnostic_Severity {
	p := new(Diagnostic_Severity)
	*p = x
	return p
}

func (x Diagnostic_Severity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Diagnostic_Severity) Descriptor() protoreflect.EnumDescriptor {
	return file_tfplugin6_proto_enumTypes[1].Descriptor()
}

func (Diagnostic_Severity) Type() protoreflect.EnumType {
	return &file_tfplugin6_proto_enumTypes[1]
}

func (x Diagnostic_Severity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Diagnostic_Severity.Descriptor instead.
func (Diagnostic_Severity) EnumDescriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{1, 0}
}

type Schema_NestedBlock_NestingMode int32

const (
	Schema_NestedBlock_INVALID Schema_NestedBlock_NestingMode = 0
	Schema_NestedBlock_SINGLE  Schema_NestedBlock_NestingMode = 1
	Schema_NestedBlock_LIST    Schema_NestedBlock_NestingMode = 2
	Schema_NestedBlock_SET     Schema_NestedBlock_NestingMode = 3
	Schema_NestedBlock_MAP     Schema_NestedBlock_NestingMode = 4
	Schema_NestedBlock_GROUP   Schema_NestedBlock_NestingMode = 5
)

// Enum value maps for Schema_NestedBlock_NestingMode.
var (
	Schema_NestedBlock_NestingMode_name = map[int32]string{
		0: "INVALID",
		1: "SINGLE",
		2: "LIST",
		3: "SET",
		4: "MAP",
		5: "GROUP",
	}
	Schema_NestedBlock_NestingMode_value = map[string]int32{
		"INVALID": 0,
		"SINGLE":  1,
		"LIST":    2,
		"SET":     3,
		"MAP":     4,
		"GROUP":   5,
	}
)

func (x Schema_NestedBlock_NestingMode) Enum() *Schema_NestedBlock_NestingMode {
	p := new(Schema_NestedBlock_NestingMode)
	*p = x
	return p
}

func (x Schema_NestedBlock_NestingMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Schema_NestedBlock_NestingMode) Descriptor() protoreflect.EnumDescriptor {
	return file_tfplugin6_proto_enumTypes[2].Descriptor()
}

func (Schema_NestedBlock_NestingMode) Type() protoreflect.EnumType {
	return &file_tfplugin6_proto_enumTypes[2]
}

func (x Schema_NestedBlock_NestingMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Schema_NestedBlock_NestingMode.Descriptor instead.
func (Schema_NestedBlock_NestingMode) EnumDescriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{6, 2, 0}
}

type Schema_Object_NestingMode int32

const (
	Schema_Object_INVALID Schema_Object_NestingMode = 0
	Schema_Object_SINGLE  Schema_Object_NestingMode = 1
	Schema_Object_LIST    Schema_Object_NestingMode = 2
	Schema_Object_SET     Schema_Object_NestingMode = 3
	Schema_Object_MAP     Schema_Object_NestingMode = 4
)

// Enum value maps for Schema_Object_NestingMode.
var (
	Schema_Object_NestingMode_name = map[int32]string{
		0: "INVALID",
		1: "SINGLE",
		2: "LIST",
		3: "SET",
		4: "MAP",
	}
	Schema_Object_NestingMode_value = map[string]int32{
		"INVALID": 0,
		"SINGLE":  1,
		"LIST":    2,
		"SET":     3,
		"MAP":     4,
	}
)

func (x Schema_Object_NestingMode) Enum() *Schema_Object_NestingMode {
	p := new(Schema_Object_NestingMode)
	*p = x
	return p
}

func (x Schema_Object_NestingMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Schema_Object_NestingMode) Descriptor() protoreflect.EnumDescriptor {
	return file_tfplugin6_proto_enumTypes[3].Descriptor()
}

func (Schema_Object_NestingMode) Type() protoreflect.EnumType {
	return &file_tfplugin6_proto_enumTypes[3]
}

func (x Schema_Object_NestingMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Schema_Object_NestingMode.Descriptor instead.
func (Schema_Object_NestingMode) EnumDescriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{6, 3, 0}
}

// Reason is the reason for deferring the change.
type Deferred_Reason int32

const (
	// UNKNOWN is the default value, and should not be used.
	Deferred_UNKNOWN Deferred_Reason = 0
	// RESOURCE_CONFIG_UNKNOWN is used when the config is partially unknown and the real
	// values need to be known before the change can be planned.
	Deferred_RESOURCE_CONFIG_UNKNOWN Deferred_Reason = 1
	// PROVIDER_CONFIG_UNKNOWN is used when parts of the provider configuration
	// are unknown, e.g. the provider configuration is only known after the apply is done.
	Deferred_PROVIDER_CONFIG_UNKNOWN Deferred_Reason = 2
	// ABSENT_PREREQ is used when a hard dependency has not been satisfied.
	Deferred_ABSENT_PREREQ Deferred_Reason = 3
)

// Enum value maps for Deferred_Reason.
var (
	Deferred_Reason_name = map[int32]string{
		0: "UNKNOWN",
		1: "RESOURCE_CONFIG_UNKNOWN",
		2: "PROVIDER_CONFIG_UNKNOWN",
		3: "ABSENT_PREREQ",
	}
	Deferred_Reason_value = map[string]int32{
		"UNKNOWN":                 0,
		"RESOURCE_CONFIG_UNKNOWN": 1,
		"PROVIDER_CONFIG_UNKNOWN": 2,
		"ABSENT_PREREQ":           3,
	}
)

func (x Deferred_Reason) Enum() *Deferred_Reason {
	p := new(Deferred_Reason)
	*p = x
	return p
}

func (x Deferred_Reason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Deferred_Reason) Descriptor() protoreflect.EnumDescriptor {
	return file_tfplugin6_proto_enumTypes[4].Descriptor()
}

func (Deferred_Reason) Type() protoreflect.EnumType {
	return &file_tfplugin6_proto_enumTypes[4]
}

func (x Deferred_Reason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Deferred_Reason.Descriptor instead.
func (Deferred_Reason) EnumDescriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{10, 0}
}

// DynamicValue is an opaque encoding of terraform data, with the field name
// indicating the encoding scheme used.
type DynamicValue struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Msgpack       []byte                 `protobuf:"bytes,1,opt,name=msgpack,proto3" json:"msgpack,omitempty"`
	Json          []byte                 `protobuf:"bytes,2,opt,name=json,proto3" json:"json,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DynamicValue) Reset() {
	*x = DynamicValue{}
	mi := &file_tfplugin6_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DynamicValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DynamicValue) ProtoMessage() {}

func (x *DynamicValue) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DynamicValue.ProtoReflect.Descriptor instead.
func (*DynamicValue) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{0}
}

func (x *DynamicValue) GetMsgpack() []byte {
	if x != nil {
		return x.Msgpack
	}
	return nil
}

func (x *DynamicValue) GetJson() []byte {
	if x != nil {
		return x.Json
	}
	return nil
}

type Diagnostic struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Severity      Diagnostic_Severity    `protobuf:"varint,1,opt,name=severity,proto3,enum=tfplugin6.Diagnostic_Severity" json:"severity,omitempty"`
	Summary       string                 `protobuf:"bytes,2,opt,name=summary,proto3" json:"summary,omitempty"`
	Detail        string                 `protobuf:"bytes,3,opt,name=detail,proto3" json:"detail,omitempty"`
	Attribute     *AttributePath         `protobuf:"bytes,4,opt,name=attribute,proto3" json:"attribute,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Diagnostic) Reset() {
	*x = Diagnostic{}
	mi := &file_tfplugin6_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Diagnostic) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Diagnostic) ProtoMessage() {}

func (x *Diagnostic) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Diagnostic.ProtoReflect.Descriptor instead.
func (*Diagnostic) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{1}
}

func (x *Diagnostic) GetSeverity() Diagnostic_Severity {
	if x != nil {
		return x.Severity
	}
	return Diagnostic_INVALID
}

func (x *Diagnostic) GetSummary() string {
	if x != nil {
		return x.Summary
	}
	return ""
}

func (x *Diagnostic) GetDetail() string {
	if x != nil {
		return x.Detail
	}
	return ""
}

func (x *Diagnostic) GetAttribute() *AttributePath {
	if x != nil {
		return x.Attribute
	}
	return nil
}

type FunctionError struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Text  string                 `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// The optional function_argument records the index position of the
	// argument which caused the error.
	FunctionArgument *int64 `protobuf:"varint,2,opt,name=function_argument,json=functionArgument,proto3,oneof" json:"function_argument,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *FunctionError) Reset() {
	*x = FunctionError{}
	mi := &file_tfplugin6_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FunctionError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunctionError) ProtoMessage() {}

func (x *FunctionError) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunctionError.ProtoReflect.Descriptor instead.
func (*FunctionError) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{2}
}

func (x *FunctionError) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *FunctionError) GetFunctionArgument() int64 {
	if x != nil && x.FunctionArgument != nil {
		return *x.FunctionArgument
	}
	return 0
}

type AttributePath struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Steps         []*AttributePath_Step  `protobuf:"bytes,1,rep,name=steps,proto3" json:"steps,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AttributePath) Reset() {
	*x = AttributePath{}
	mi := &file_tfplugin6_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttributePath) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributePath) ProtoMessage() {}

func (x *AttributePath) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributePath.ProtoReflect.Descriptor instead.
func (*AttributePath) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{3}
}

func (x *AttributePath) GetSteps() []*AttributePath_Step {
	if x != nil {
		return x.Steps
	}
	return nil
}

type StopProvider struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StopProvider) Reset() {
	*x = StopProvider{}
	mi := &file_tfplugin6_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StopProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopProvider) ProtoMessage() {}

func (x *StopProvider) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopProvider.ProtoReflect.Descriptor instead.
func (*StopProvider) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{4}
}

// RawState holds the stored state for a resource to be upgraded by the
// provider. It can be in one of two formats, the current json encoded format
// in bytes, or the legacy flatmap format as a map of strings.
type RawState struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Json          []byte                 `protobuf:"bytes,1,opt,name=json,proto3" json:"json,omitempty"`
	Flatmap       map[string]string      `protobuf:"bytes,2,rep,name=flatmap,proto3" json:"flatmap,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RawState) Reset() {
	*x = RawState{}
	mi := &file_tfplugin6_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RawState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RawState) ProtoMessage() {}

func (x *RawState) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RawState.ProtoReflect.Descriptor instead.
func (*RawState) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{5}
}

func (x *RawState) GetJson() []byte {
	if x != nil {
		return x.Json
	}
	return nil
}

func (x *RawState) GetFlatmap() map[string]string {
	if x != nil {
		return x.Flatmap
	}
	return nil
}

// Schema is the configuration schema for a Resource or Provider.
type Schema struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The version of the schema.
	// Schemas are versioned, so that providers can upgrade a saved resource
	// state when the schema is changed.
	Version int64 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// Block is the top level configuration block for this schema.
	Block         *Schema_Block `protobuf:"bytes,2,opt,name=block,proto3" json:"block,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Schema) Reset() {
	*x = Schema{}
	mi := &file_tfplugin6_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Schema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schema) ProtoMessage() {}

func (x *Schema) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schema.ProtoReflect.Descriptor instead.
func (*Schema) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{6}
}

func (x *Schema) GetVersion() int64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *Schema) GetBlock() *Schema_Block {
	if x != nil {
		return x.Block
	}
	return nil
}

type Function struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// parameters is the ordered list of positional function parameters.
	Parameters []*Function_Parameter `protobuf:"bytes,1,rep,name=parameters,proto3" json:"parameters,omitempty"`
	// variadic_parameter is an optional final parameter which accepts
	// zero or more argument values, in which Terraform will send an
	// ordered list of the parameter type.
	VariadicParameter *Function_Parameter `protobuf:"bytes,2,opt,name=variadic_parameter,json=variadicParameter,proto3" json:"variadic_parameter,omitempty"`
	// return is the function result.
	Return *Function_Return `protobuf:"bytes,3,opt,name=return,proto3" json:"return,omitempty"`
	// summary is the human-readable shortened documentation for the function.
	Summary string `protobuf:"bytes,4,opt,name=summary,proto3" json:"summary,omitempty"`
	// description is human-readable documentation for the function.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// description_kind is the formatting of the description.
	DescriptionKind StringKind `protobuf:"varint,6,opt,name=description_kind,json=descriptionKind,proto3,enum=tfplugin6.StringKind" json:"description_kind,omitempty"`
	// deprecation_message is human-readable documentation if the
	// function is deprecated.
	DeprecationMessage string `protobuf:"bytes,7,opt,name=deprecation_message,json=deprecationMessage,proto3" json:"deprecation_message,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *Function) Reset() {
	*x = Function{}
	mi := &file_tfplugin6_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Function) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Function) ProtoMessage() {}

func (x *Function) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Function.ProtoReflect.Descriptor instead.
func (*Function) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{7}
}

func (x *Function) GetParameters() []*Function_Parameter {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *Function) GetVariadicParameter() *Function_Parameter {
	if x != nil {
		return x.VariadicParameter
	}
	return nil
}

func (x *Function) GetReturn() *Function_Return {
	if x != nil {
		return x.Return
	}
	return nil
}

func (x *Function) GetSummary() string {
	if x != nil {
		return x.Summary
	}
	return ""
}

func (x *Function) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Function) GetDescriptionKind() StringKind {
	if x != nil {
		return x.DescriptionKind
	}
	return StringKind_PLAIN
}

func (x *Function) GetDeprecationMessage() string {
	if x != nil {
		return x.DeprecationMessage
	}
	return ""
}

// ServerCapabilities allows providers to communicate extra information
// regarding supported protocol features. This is used to indicate
// availability of certain forward-compatible changes which may be optional
// in a major protocol version, but cannot be tested for directly.
type ServerCapabilities struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The plan_destroy capability signals that a provider expects a call
	// to PlanResourceChange when a resource is going to be destroyed.
	PlanDestroy bool `protobuf:"varint,1,opt,name=plan_destroy,json=planDestroy,proto3" json:"plan_destroy,omitempty"`
	// The get_provider_schema_optional capability indicates that this
	// provider does not require calling GetProviderSchema to operate
	// normally, and the caller can used a cached copy of the provider's
	// schema.
	GetProviderSchemaOptional bool `protobuf:"varint,2,opt,name=get_provider_schema_optional,json=getProviderSchemaOptional,proto3" json:"get_provider_schema_optional,omitempty"`
	// The move_resource_state capability signals that a provider supports the
	// MoveResourceState RPC.
	MoveResourceState bool `protobuf:"varint,3,opt,name=move_resource_state,json=moveResourceState,proto3" json:"move_resource_state,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *ServerCapabilities) Reset() {
	*x = ServerCapabilities{}
	mi := &file_tfplugin6_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServerCapabilities) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServerCapabilities) ProtoMessage() {}

func (x *ServerCapabilities) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServerCapabilities.ProtoReflect.Descriptor instead.
func (*ServerCapabilities) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{8}
}

func (x *ServerCapabilities) GetPlanDestroy() bool {
	if x != nil {
		return x.PlanDestroy
	}
	return false
}

func (x *ServerCapabilities) GetGetProviderSchemaOptional() bool {
	if x != nil {
		return x.GetProviderSchemaOptional
	}
	return false
}

func (x *ServerCapabilities) GetMoveResourceState() bool {
	if x != nil {
		return x.MoveResourceState
	}
	return false
}

// ClientCapabilities allows Terraform to publish information regarding
// supported protocol features. This is used to indicate availability of
// certain forward-compatible changes which may be optional in a major
// protocol version, but cannot be tested for directly.
type ClientCapabilities struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The deferral_allowed capability signals that the client is able to
	// handle deferred responses from the provider.
	DeferralAllowed bool `protobuf:"varint,1,opt,name=deferral_allowed,json=deferralAllowed,proto3" json:"deferral_allowed,omitempty"`
	// The write_only_attributes_allowed capability signals that the client
	// is able to handle write_only attributes for managed resources.
	WriteOnlyAttributesAllowed bool `protobuf:"varint,2,opt,name=write_only_attributes_allowed,json=writeOnlyAttributesAllowed,proto3" json:"write_only_attributes_allowed,omitempty"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *ClientCapabilities) Reset() {
	*x = ClientCapabilities{}
	mi := &file_tfplugin6_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClientCapabilities) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientCapabilities) ProtoMessage() {}

func (x *ClientCapabilities) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientCapabilities.ProtoReflect.Descriptor instead.
func (*ClientCapabilities) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{9}
}

func (x *ClientCapabilities) GetDeferralAllowed() bool {
	if x != nil {
		return x.DeferralAllowed
	}
	return false
}

func (x *ClientCapabilities) GetWriteOnlyAttributesAllowed() bool {
	if x != nil {
		return x.WriteOnlyAttributesAllowed
	}
	return false
}

// Deferred is a message that indicates that change is deferred for a reason.
type Deferred struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// reason is the reason for deferring the change.
	Reason        Deferred_Reason `protobuf:"varint,1,opt,name=reason,proto3,enum=tfplugin6.Deferred_Reason" json:"reason,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Deferred) Reset() {
	*x = Deferred{}
	mi := &file_tfplugin6_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Deferred) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Deferred) ProtoMessage() {}

func (x *Deferred) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Deferred.ProtoReflect.Descriptor instead.
func (*Deferred) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{10}
}

func (x *Deferred) GetReason() Deferred_Reason {
	if x != nil {
		return x.Reason
	}
	return Deferred_UNKNOWN
}

type GetMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetMetadata) Reset() {
	*x = GetMetadata{}
	mi := &file_tfplugin6_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadata) ProtoMessage() {}

func (x *GetMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadata.ProtoReflect.Descriptor instead.
func (*GetMetadata) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{11}
}

type GetProviderSchema struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetProviderSchema) Reset() {
	*x = GetProviderSchema{}
	mi := &file_tfplugin6_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetProviderSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProviderSchema) ProtoMessage() {}

func (x *GetProviderSchema) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProviderSchema.ProtoReflect.Descriptor instead.
func (*GetProviderSchema) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{12}
}

type ValidateProviderConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateProviderConfig) Reset() {
	*x = ValidateProviderConfig{}
	mi := &file_tfplugin6_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateProviderConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateProviderConfig) ProtoMessage() {}

func (x *ValidateProviderConfig) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateProviderConfig.ProtoReflect.Descriptor instead.
func (*ValidateProviderConfig) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{13}
}

type UpgradeResourceState struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpgradeResourceState) Reset() {
	*x = UpgradeResourceState{}
	mi := &file_tfplugin6_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpgradeResourceState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeResourceState) ProtoMessage() {}

func (x *UpgradeResourceState) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeResourceState.ProtoReflect.Descriptor instead.
func (*UpgradeResourceState) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{14}
}

type ValidateResourceConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateResourceConfig) Reset() {
	*x = ValidateResourceConfig{}
	mi := &file_tfplugin6_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateResourceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateResourceConfig) ProtoMessage() {}

func (x *ValidateResourceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateResourceConfig.ProtoReflect.Descriptor instead.
func (*ValidateResourceConfig) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{15}
}

type ValidateDataResourceConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateDataResourceConfig) Reset() {
	*x = ValidateDataResourceConfig{}
	mi := &file_tfplugin6_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateDataResourceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateDataResourceConfig) ProtoMessage() {}

func (x *ValidateDataResourceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateDataResourceConfig.ProtoReflect.Descriptor instead.
func (*ValidateDataResourceConfig) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{16}
}

type ConfigureProvider struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ConfigureProvider) Reset() {
	*x = ConfigureProvider{}
	mi := &file_tfplugin6_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConfigureProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigureProvider) ProtoMessage() {}

func (x *ConfigureProvider) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigureProvider.ProtoReflect.Descriptor instead.
func (*ConfigureProvider) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{17}
}

type ReadResource struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReadResource) Reset() {
	*x = ReadResource{}
	mi := &file_tfplugin6_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadResource) ProtoMessage() {}

func (x *ReadResource) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadResource.ProtoReflect.Descriptor instead.
func (*ReadResource) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{18}
}

type PlanResourceChange struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PlanResourceChange) Reset() {
	*x = PlanResourceChange{}
	mi := &file_tfplugin6_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlanResourceChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlanResourceChange) ProtoMessage() {}

func (x *PlanResourceChange) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlanResourceChange.ProtoReflect.Descriptor instead.
func (*PlanResourceChange) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{19}
}

type ApplyResourceChange struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ApplyResourceChange) Reset() {
	*x = ApplyResourceChange{}
	mi := &file_tfplugin6_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApplyResourceChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyResourceChange) ProtoMessage() {}

func (x *ApplyResourceChange) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyResourceChange.ProtoReflect.Descriptor instead.
func (*ApplyResourceChange) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{20}
}

type ImportResourceState struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ImportResourceState) Reset() {
	*x = ImportResourceState{}
	mi := &file_tfplugin6_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportResourceState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportResourceState) ProtoMessage() {}

func (x *ImportResourceState) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportResourceState.ProtoReflect.Descriptor instead.
func (*ImportResourceState) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{21}
}

type MoveResourceState struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MoveResourceState) Reset() {
	*x = MoveResourceState{}
	mi := &file_tfplugin6_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MoveResourceState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveResourceState) ProtoMessage() {}

func (x *MoveResourceState) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveResourceState.ProtoReflect.Descriptor instead.
func (*MoveResourceState) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{22}
}

type ReadDataSource struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReadDataSource) Reset() {
	*x = ReadDataSource{}
	mi := &file_tfplugin6_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadDataSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadDataSource) ProtoMessage() {}

func (x *ReadDataSource) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadDataSource.ProtoReflect.Descriptor instead.
func (*ReadDataSource) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{23}
}

type GetFunctions struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetFunctions) Reset() {
	*x = GetFunctions{}
	mi := &file_tfplugin6_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetFunctions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFunctions) ProtoMessage() {}

func (x *GetFunctions) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFunctions.ProtoReflect.Descriptor instead.
func (*GetFunctions) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{24}
}

type CallFunction struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CallFunction) Reset() {
	*x = CallFunction{}
	mi := &file_tfplugin6_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CallFunction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CallFunction) ProtoMessage() {}

func (x *CallFunction) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CallFunction.ProtoReflect.Descriptor instead.
func (*CallFunction) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{25}
}

type ValidateEphemeralResourceConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateEphemeralResourceConfig) Reset() {
	*x = ValidateEphemeralResourceConfig{}
	mi := &file_tfplugin6_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateEphemeralResourceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateEphemeralResourceConfig) ProtoMessage() {}

func (x *ValidateEphemeralResourceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateEphemeralResourceConfig.ProtoReflect.Descriptor instead.
func (*ValidateEphemeralResourceConfig) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{26}
}

type OpenEphemeralResource struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OpenEphemeralResource) Reset() {
	*x = OpenEphemeralResource{}
	mi := &file_tfplugin6_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpenEphemeralResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenEphemeralResource) ProtoMessage() {}

func (x *OpenEphemeralResource) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenEphemeralResource.ProtoReflect.Descriptor instead.
func (*OpenEphemeralResource) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{27}
}

type RenewEphemeralResource struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RenewEphemeralResource) Reset() {
	*x = RenewEphemeralResource{}
	mi := &file_tfplugin6_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RenewEphemeralResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenewEphemeralResource) ProtoMessage() {}

func (x *RenewEphemeralResource) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RenewEphemeralResource.ProtoReflect.Descriptor instead.
func (*RenewEphemeralResource) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{28}
}

type CloseEphemeralResource struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CloseEphemeralResource) Reset() {
	*x = CloseEphemeralResource{}
	mi := &file_tfplugin6_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloseEphemeralResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseEphemeralResource) ProtoMessage() {}

func (x *CloseEphemeralResource) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseEphemeralResource.ProtoReflect.Descriptor instead.
func (*CloseEphemeralResource) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{29}
}

type AttributePath_Step struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Selector:
	//
	//	*AttributePath_Step_AttributeName
	//	*AttributePath_Step_ElementKeyString
	//	*AttributePath_Step_ElementKeyInt
	Selector      isAttributePath_Step_Selector `protobuf_oneof:"selector"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AttributePath_Step) Reset() {
	*x = AttributePath_Step{}
	mi := &file_tfplugin6_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttributePath_Step) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributePath_Step) ProtoMessage() {}

func (x *AttributePath_Step) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributePath_Step.ProtoReflect.Descriptor instead.
func (*AttributePath_Step) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{3, 0}
}

func (x *AttributePath_Step) GetSelector() isAttributePath_Step_Selector {
	if x != nil {
		return x.Selector
	}
	return nil
}

func (x *AttributePath_Step) GetAttributeName() string {
	if x != nil {
		if x, ok := x.Selector.(*AttributePath_Step_AttributeName); ok {
			return x.AttributeName
		}
	}
	return ""
}

func (x *AttributePath_Step) GetElementKeyString() string {
	if x != nil {
		if x, ok := x.Selector.(*AttributePath_Step_ElementKeyString); ok {
			return x.ElementKeyString
		}
	}
	return ""
}

func (x *AttributePath_Step) GetElementKeyInt() int64 {
	if x != nil {
		if x, ok := x.Selector.(*AttributePath_Step_ElementKeyInt); ok {
			return x.ElementKeyInt
		}
	}
	return 0
}

type isAttributePath_Step_Selector interface {
	isAttributePath_Step_Selector()
}

type AttributePath_Step_AttributeName struct {
	// Set "attribute_name" to represent looking up an attribute
	// in the current object value.
	AttributeName string `protobuf:"bytes,1,opt,name=attribute_name,json=attributeName,proto3,oneof"`
}

type AttributePath_Step_ElementKeyString struct {
	// Set "element_key_*" to represent looking up an element in
	// an indexable collection type.
	ElementKeyString string `protobuf:"bytes,2,opt,name=element_key_string,json=elementKeyString,proto3,oneof"`
}

type AttributePath_Step_ElementKeyInt struct {
	ElementKeyInt int64 `protobuf:"varint,3,opt,name=element_key_int,json=elementKeyInt,proto3,oneof"`
}

func (*AttributePath_Step_AttributeName) isAttributePath_Step_Selector() {}

func (*AttributePath_Step_ElementKeyString) isAttributePath_Step_Selector() {}

func (*AttributePath_Step_ElementKeyInt) isAttributePath_Step_Selector() {}

type StopProvider_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StopProvider_Request) Reset() {
	*x = StopProvider_Request{}
	mi := &file_tfplugin6_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StopProvider_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopProvider_Request) ProtoMessage() {}

func (x *StopProvider_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopProvider_Request.ProtoReflect.Descriptor instead.
func (*StopProvider_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{4, 0}
}

type StopProvider_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Error         string                 `protobuf:"bytes,1,opt,name=Error,proto3" json:"Error,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StopProvider_Response) Reset() {
	*x = StopProvider_Response{}
	mi := &file_tfplugin6_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StopProvider_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopProvider_Response) ProtoMessage() {}

func (x *StopProvider_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopProvider_Response.ProtoReflect.Descriptor instead.
func (*StopProvider_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{4, 1}
}

func (x *StopProvider_Response) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

type Schema_Block struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	Version         int64                  `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	Attributes      []*Schema_Attribute    `protobuf:"bytes,2,rep,name=attributes,proto3" json:"attributes,omitempty"`
	BlockTypes      []*Schema_NestedBlock  `protobuf:"bytes,3,rep,name=block_types,json=blockTypes,proto3" json:"block_types,omitempty"`
	Description     string                 `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	DescriptionKind StringKind             `protobuf:"varint,5,opt,name=description_kind,json=descriptionKind,proto3,enum=tfplugin6.StringKind" json:"description_kind,omitempty"`
	Deprecated      bool                   `protobuf:"varint,6,opt,name=deprecated,proto3" json:"deprecated,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *Schema_Block) Reset() {
	*x = Schema_Block{}
	mi := &file_tfplugin6_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Schema_Block) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schema_Block) ProtoMessage() {}

func (x *Schema_Block) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schema_Block.ProtoReflect.Descriptor instead.
func (*Schema_Block) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{6, 0}
}

func (x *Schema_Block) GetVersion() int64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *Schema_Block) GetAttributes() []*Schema_Attribute {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *Schema_Block) GetBlockTypes() []*Schema_NestedBlock {
	if x != nil {
		return x.BlockTypes
	}
	return nil
}

func (x *Schema_Block) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Schema_Block) GetDescriptionKind() StringKind {
	if x != nil {
		return x.DescriptionKind
	}
	return StringKind_PLAIN
}

func (x *Schema_Block) GetDeprecated() bool {
	if x != nil {
		return x.Deprecated
	}
	return false
}

type Schema_Attribute struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	Name            string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Type            []byte                 `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	NestedType      *Schema_Object         `protobuf:"bytes,10,opt,name=nested_type,json=nestedType,proto3" json:"nested_type,omitempty"`
	Description     string                 `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	Required        bool                   `protobuf:"varint,4,opt,name=required,proto3" json:"required,omitempty"`
	Optional        bool                   `protobuf:"varint,5,opt,name=optional,proto3" json:"optional,omitempty"`
	Computed        bool                   `protobuf:"varint,6,opt,name=computed,proto3" json:"computed,omitempty"`
	Sensitive       bool                   `protobuf:"varint,7,opt,name=sensitive,proto3" json:"sensitive,omitempty"`
	DescriptionKind StringKind             `protobuf:"varint,8,opt,name=description_kind,json=descriptionKind,proto3,enum=tfplugin6.StringKind" json:"description_kind,omitempty"`
	Deprecated      bool                   `protobuf:"varint,9,opt,name=deprecated,proto3" json:"deprecated,omitempty"`
	// write_only indicates that the attribute value will be provided via
	// configuration and must be omitted from state. write_only must be
	// combined with optional or required, and is only valid for managed
	// resource schemas.
	WriteOnly     bool `protobuf:"varint,11,opt,name=write_only,json=writeOnly,proto3" json:"write_only,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Schema_Attribute) Reset() {
	*x = Schema_Attribute{}
	mi := &file_tfplugin6_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Schema_Attribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schema_Attribute) ProtoMessage() {}

func (x *Schema_Attribute) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schema_Attribute.ProtoReflect.Descriptor instead.
func (*Schema_Attribute) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{6, 1}
}

func (x *Schema_Attribute) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Schema_Attribute) GetType() []byte {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *Schema_Attribute) GetNestedType() *Schema_Object {
	if x != nil {
		return x.NestedType
	}
	return nil
}

func (x *Schema_Attribute) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Schema_Attribute) GetRequired() bool {
	if x != nil {
		return x.Required
	}
	return false
}

func (x *Schema_Attribute) GetOptional() bool {
	if x != nil {
		return x.Optional
	}
	return false
}

func (x *Schema_Attribute) GetComputed() bool {
	if x != nil {
		return x.Computed
	}
	return false
}

func (x *Schema_Attribute) GetSensitive() bool {
	if x != nil {
		return x.Sensitive
	}
	return false
}

func (x *Schema_Attribute) GetDescriptionKind() StringKind {
	if x != nil {
		return x.DescriptionKind
	}
	return StringKind_PLAIN
}

func (x *Schema_Attribute) GetDeprecated() bool {
	if x != nil {
		return x.Deprecated
	}
	return false
}

func (x *Schema_Attribute) GetWriteOnly() bool {
	if x != nil {
		return x.WriteOnly
	}
	return false
}

type Schema_NestedBlock struct {
	state         protoimpl.MessageState         `protogen:"open.v1"`
	TypeName      string                         `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Block         *Schema_Block                  `protobuf:"bytes,2,opt,name=block,proto3" json:"block,omitempty"`
	Nesting       Schema_NestedBlock_NestingMode `protobuf:"varint,3,opt,name=nesting,proto3,enum=tfplugin6.Schema_NestedBlock_NestingMode" json:"nesting,omitempty"`
	MinItems      int64                          `protobuf:"varint,4,opt,name=min_items,json=minItems,proto3" json:"min_items,omitempty"`
	MaxItems      int64                          `protobuf:"varint,5,opt,name=max_items,json=maxItems,proto3" json:"max_items,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Schema_NestedBlock) Reset() {
	*x = Schema_NestedBlock{}
	mi := &file_tfplugin6_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Schema_NestedBlock) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schema_NestedBlock) ProtoMessage() {}

func (x *Schema_NestedBlock) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schema_NestedBlock.ProtoReflect.Descriptor instead.
func (*Schema_NestedBlock) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{6, 2}
}

func (x *Schema_NestedBlock) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *Schema_NestedBlock) GetBlock() *Schema_Block {
	if x != nil {
		return x.Block
	}
	return nil
}

func (x *Schema_NestedBlock) GetNesting() Schema_NestedBlock_NestingMode {
	if x != nil {
		return x.Nesting
	}
	return Schema_NestedBlock_INVALID
}

func (x *Schema_NestedBlock) GetMinItems() int64 {
	if x != nil {
		return x.MinItems
	}
	return 0
}

func (x *Schema_NestedBlock) GetMaxItems() int64 {
	if x != nil {
		return x.MaxItems
	}
	return 0
}

type Schema_Object struct {
	state      protoimpl.MessageState    `protogen:"open.v1"`
	Attributes []*Schema_Attribute       `protobuf:"bytes,1,rep,name=attributes,proto3" json:"attributes,omitempty"`
	Nesting    Schema_Object_NestingMode `protobuf:"varint,3,opt,name=nesting,proto3,enum=tfplugin6.Schema_Object_NestingMode" json:"nesting,omitempty"`
	// MinItems and MaxItems were never used in the protocol, and have no
	// effect on validation.
	//
	// Deprecated: Marked as deprecated in tfplugin6.proto.
	MinItems int64 `protobuf:"varint,4,opt,name=min_items,json=minItems,proto3" json:"min_items,omitempty"`
	// Deprecated: Marked as deprecated in tfplugin6.proto.
	MaxItems      int64 `protobuf:"varint,5,opt,name=max_items,json=maxItems,proto3" json:"max_items,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Schema_Object) Reset() {
	*x = Schema_Object{}
	mi := &file_tfplugin6_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Schema_Object) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schema_Object) ProtoMessage() {}

func (x *Schema_Object) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schema_Object.ProtoReflect.Descriptor instead.
func (*Schema_Object) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{6, 3}
}

func (x *Schema_Object) GetAttributes() []*Schema_Attribute {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *Schema_Object) GetNesting() Schema_Object_NestingMode {
	if x != nil {
		return x.Nesting
	}
	return Schema_Object_INVALID
}

// Deprecated: Marked as deprecated in tfplugin6.proto.
func (x *Schema_Object) GetMinItems() int64 {
	if x != nil {
		return x.MinItems
	}
	return 0
}

// Deprecated: Marked as deprecated in tfplugin6.proto.
func (x *Schema_Object) GetMaxItems() int64 {
	if x != nil {
		return x.MaxItems
	}
	return 0
}

type Function_Parameter struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// name is the human-readable display name for the parameter.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// type is the type constraint for the parameter.
	Type []byte `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// allow_null_value when enabled denotes that a null argument value can
	// be passed to the provider. When disabled, Terraform returns an error
	// if the argument value is null.
	AllowNullValue bool `protobuf:"varint,3,opt,name=allow_null_value,json=allowNullValue,proto3" json:"allow_null_value,omitempty"`
	// allow_unknown_values when enabled denotes that only wholly known
	// argument values will be passed to the provider. When disabled,
	// Terraform skips the function call entirely and assumes an unknown
	// value result from the function.
	AllowUnknownValues bool `protobuf:"varint,4,opt,name=allow_unknown_values,json=allowUnknownValues,proto3" json:"allow_unknown_values,omitempty"`
	// description is human-readable documentation for the parameter.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// description_kind is the formatting of the description.
	DescriptionKind StringKind `protobuf:"varint,6,opt,name=description_kind,json=descriptionKind,proto3,enum=tfplugin6.StringKind" json:"description_kind,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *Function_Parameter) Reset() {
	*x = Function_Parameter{}
	mi := &file_tfplugin6_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Function_Parameter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Function_Parameter) ProtoMessage() {}

func (x *Function_Parameter) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Function_Parameter.ProtoReflect.Descriptor instead.
func (*Function_Parameter) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{7, 0}
}

func (x *Function_Parameter) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Function_Parameter) GetType() []byte {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *Function_Parameter) GetAllowNullValue() bool {
	if x != nil {
		return x.AllowNullValue
	}
	return false
}

func (x *Function_Parameter) GetAllowUnknownValues() bool {
	if x != nil {
		return x.AllowUnknownValues
	}
	return false
}

func (x *Function_Parameter) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Function_Parameter) GetDescriptionKind() StringKind {
	if x != nil {
		return x.DescriptionKind
	}
	return StringKind_PLAIN
}

type Function_Return struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// type is the type constraint for the function result.
	Type          []byte `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Function_Return) Reset() {
	*x = Function_Return{}
	mi := &file_tfplugin6_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Function_Return) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Function_Return) ProtoMessage() {}

func (x *Function_Return) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Function_Return.ProtoReflect.Descriptor instead.
func (*Function_Return) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{7, 1}
}

func (x *Function_Return) GetType() []byte {
	if x != nil {
		return x.Type
	}
	return nil
}

type GetMetadata_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetMetadata_Request) Reset() {
	*x = GetMetadata_Request{}
	mi := &file_tfplugin6_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMetadata_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadata_Request) ProtoMessage() {}

func (x *GetMetadata_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadata_Request.ProtoReflect.Descriptor instead.
func (*GetMetadata_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{11, 0}
}

type GetMetadata_Response struct {
	state              protoimpl.MessageState            `protogen:"open.v1"`
	ServerCapabilities *ServerCapabilities               `protobuf:"bytes,1,opt,name=server_capabilities,json=serverCapabilities,proto3" json:"server_capabilities,omitempty"`
	Diagnostics        []*Diagnostic                     `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	DataSources        []*GetMetadata_DataSourceMetadata `protobuf:"bytes,3,rep,name=data_sources,json=dataSources,proto3" json:"data_sources,omitempty"`
	Resources          []*GetMetadata_ResourceMetadata   `protobuf:"bytes,4,rep,name=resources,proto3" json:"resources,omitempty"`
	// functions returns metadata for any functions.
	Functions          []*GetMetadata_FunctionMetadata          `protobuf:"bytes,5,rep,name=functions,proto3" json:"functions,omitempty"`
	EphemeralResources []*GetMetadata_EphemeralResourceMetadata `protobuf:"bytes,6,rep,name=ephemeral_resources,json=ephemeralResources,proto3" json:"ephemeral_resources,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *GetMetadata_Response) Reset() {
	*x = GetMetadata_Response{}
	mi := &file_tfplugin6_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMetadata_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadata_Response) ProtoMessage() {}

func (x *GetMetadata_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadata_Response.ProtoReflect.Descriptor instead.
func (*GetMetadata_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{11, 1}
}

func (x *GetMetadata_Response) GetServerCapabilities() *ServerCapabilities {
	if x != nil {
		return x.ServerCapabilities
	}
	return nil
}

func (x *GetMetadata_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *GetMetadata_Response) GetDataSources() []*GetMetadata_DataSourceMetadata {
	if x != nil {
		return x.DataSources
	}
	return nil
}

func (x *GetMetadata_Response) GetResources() []*GetMetadata_ResourceMetadata {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *GetMetadata_Response) GetFunctions() []*GetMetadata_FunctionMetadata {
	if x != nil {
		return x.Functions
	}
	return nil
}

func (x *GetMetadata_Response) GetEphemeralResources() []*GetMetadata_EphemeralResourceMetadata {
	if x != nil {
		return x.EphemeralResources
	}
	return nil
}

type GetMetadata_FunctionMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// name is the function name.
	Name          string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetMetadata_FunctionMetadata) Reset() {
	*x = GetMetadata_FunctionMetadata{}
	mi := &file_tfplugin6_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMetadata_FunctionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadata_FunctionMetadata) ProtoMessage() {}

func (x *GetMetadata_FunctionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadata_FunctionMetadata.ProtoReflect.Descriptor instead.
func (*GetMetadata_FunctionMetadata) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{11, 2}
}

func (x *GetMetadata_FunctionMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type GetMetadata_DataSourceMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetMetadata_DataSourceMetadata) Reset() {
	*x = GetMetadata_DataSourceMetadata{}
	mi := &file_tfplugin6_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMetadata_DataSourceMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadata_DataSourceMetadata) ProtoMessage() {}

func (x *GetMetadata_DataSourceMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadata_DataSourceMetadata.ProtoReflect.Descriptor instead.
func (*GetMetadata_DataSourceMetadata) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{11, 3}
}

func (x *GetMetadata_DataSourceMetadata) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

type GetMetadata_ResourceMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetMetadata_ResourceMetadata) Reset() {
	*x = GetMetadata_ResourceMetadata{}
	mi := &file_tfplugin6_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMetadata_ResourceMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadata_ResourceMetadata) ProtoMessage() {}

func (x *GetMetadata_ResourceMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadata_ResourceMetadata.ProtoReflect.Descriptor instead.
func (*GetMetadata_ResourceMetadata) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{11, 4}
}

func (x *GetMetadata_ResourceMetadata) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

type GetMetadata_EphemeralResourceMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetMetadata_EphemeralResourceMetadata) Reset() {
	*x = GetMetadata_EphemeralResourceMetadata{}
	mi := &file_tfplugin6_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMetadata_EphemeralResourceMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadata_EphemeralResourceMetadata) ProtoMessage() {}

func (x *GetMetadata_EphemeralResourceMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadata_EphemeralResourceMetadata.ProtoReflect.Descriptor instead.
func (*GetMetadata_EphemeralResourceMetadata) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{11, 5}
}

func (x *GetMetadata_EphemeralResourceMetadata) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

type GetProviderSchema_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetProviderSchema_Request) Reset() {
	*x = GetProviderSchema_Request{}
	mi := &file_tfplugin6_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetProviderSchema_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProviderSchema_Request) ProtoMessage() {}

func (x *GetProviderSchema_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProviderSchema_Request.ProtoReflect.Descriptor instead.
func (*GetProviderSchema_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{12, 0}
}

type GetProviderSchema_Response struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	Provider           *Schema                `protobuf:"bytes,1,opt,name=provider,proto3" json:"provider,omitempty"`
	ResourceSchemas    map[string]*Schema     `protobuf:"bytes,2,rep,name=resource_schemas,json=resourceSchemas,proto3" json:"resource_schemas,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	DataSourceSchemas  map[string]*Schema     `protobuf:"bytes,3,rep,name=data_source_schemas,json=dataSourceSchemas,proto3" json:"data_source_schemas,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Diagnostics        []*Diagnostic          `protobuf:"bytes,4,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	ProviderMeta       *Schema                `protobuf:"bytes,5,opt,name=provider_meta,json=providerMeta,proto3" json:"provider_meta,omitempty"`
	ServerCapabilities *ServerCapabilities    `protobuf:"bytes,6,opt,name=server_capabilities,json=serverCapabilities,proto3" json:"server_capabilities,omitempty"`
	// functions is a mapping of function names to definitions.
	Functions                map[string]*Function `protobuf:"bytes,7,rep,name=functions,proto3" json:"functions,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	EphemeralResourceSchemas map[string]*Schema   `protobuf:"bytes,8,rep,name=ephemeral_resource_schemas,json=ephemeralResourceSchemas,proto3" json:"ephemeral_resource_schemas,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *GetProviderSchema_Response) Reset() {
	*x = GetProviderSchema_Response{}
	mi := &file_tfplugin6_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetProviderSchema_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProviderSchema_Response) ProtoMessage() {}

func (x *GetProviderSchema_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProviderSchema_Response.ProtoReflect.Descriptor instead.
func (*GetProviderSchema_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{12, 1}
}

func (x *GetProviderSchema_Response) GetProvider() *Schema {
	if x != nil {
		return x.Provider
	}
	return nil
}

func (x *GetProviderSchema_Response) GetResourceSchemas() map[string]*Schema {
	if x != nil {
		return x.ResourceSchemas
	}
	return nil
}

func (x *GetProviderSchema_Response) GetDataSourceSchemas() map[string]*Schema {
	if x != nil {
		return x.DataSourceSchemas
	}
	return nil
}

func (x *GetProviderSchema_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *GetProviderSchema_Response) GetProviderMeta() *Schema {
	if x != nil {
		return x.ProviderMeta
	}
	return nil
}

func (x *GetProviderSchema_Response) GetServerCapabilities() *ServerCapabilities {
	if x != nil {
		return x.ServerCapabilities
	}
	return nil
}

func (x *GetProviderSchema_Response) GetFunctions() map[string]*Function {
	if x != nil {
		return x.Functions
	}
	return nil
}

func (x *GetProviderSchema_Response) GetEphemeralResourceSchemas() map[string]*Schema {
	if x != nil {
		return x.EphemeralResourceSchemas
	}
	return nil
}

type ValidateProviderConfig_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Config        *DynamicValue          `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateProviderConfig_Request) Reset() {
	*x = ValidateProviderConfig_Request{}
	mi := &file_tfplugin6_proto_msgTypes[52]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateProviderConfig_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateProviderConfig_Request) ProtoMessage() {}

func (x *ValidateProviderConfig_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[52]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateProviderConfig_Request.ProtoReflect.Descriptor instead.
func (*ValidateProviderConfig_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{13, 0}
}

func (x *ValidateProviderConfig_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

type ValidateProviderConfig_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateProviderConfig_Response) Reset() {
	*x = ValidateProviderConfig_Response{}
	mi := &file_tfplugin6_proto_msgTypes[53]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateProviderConfig_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateProviderConfig_Response) ProtoMessage() {}

func (x *ValidateProviderConfig_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[53]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateProviderConfig_Response.ProtoReflect.Descriptor instead.
func (*ValidateProviderConfig_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{13, 1}
}

func (x *ValidateProviderConfig_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

// Request is the message that is sent to the provider during the
// UpgradeResourceState RPC.
//
// This message intentionally does not include configuration data as any
// configuration-based or configuration-conditional changes should occur
// during the PlanResourceChange RPC. Additionally, the configuration is
// not guaranteed to exist (in the case of resource destruction), be wholly
// known, nor match the given prior state, which could lead to unexpected
// provider behaviors for practitioners.
type UpgradeResourceState_Request struct {
	state    protoimpl.MessageState `protogen:"open.v1"`
	TypeName string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	// version is the schema_version number recorded in the state file
	Version int64 `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
	// raw_state is the raw states as stored for the resource.  Core does
	// not have access to the schema of prior_version, so it's the
	// provider's responsibility to interpret this value using the
	// appropriate older schema. The raw_state will be the json encoded
	// state, or a legacy flat-mapped format.
	RawState      *RawState `protobuf:"bytes,3,opt,name=raw_state,json=rawState,proto3" json:"raw_state,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpgradeResourceState_Request) Reset() {
	*x = UpgradeResourceState_Request{}
	mi := &file_tfplugin6_proto_msgTypes[54]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpgradeResourceState_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeResourceState_Request) ProtoMessage() {}

func (x *UpgradeResourceState_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[54]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeResourceState_Request.ProtoReflect.Descriptor instead.
func (*UpgradeResourceState_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{14, 0}
}

func (x *UpgradeResourceState_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *UpgradeResourceState_Request) GetVersion() int64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *UpgradeResourceState_Request) GetRawState() *RawState {
	if x != nil {
		return x.RawState
	}
	return nil
}

type UpgradeResourceState_Response struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// new_state is a msgpack-encoded data structure that, when interpreted with
	// the _current_ schema for this resource type, is functionally equivalent to
	// that which was given in prior_state_raw.
	UpgradedState *DynamicValue `protobuf:"bytes,1,opt,name=upgraded_state,json=upgradedState,proto3" json:"upgraded_state,omitempty"`
	// diagnostics describes any errors encountered during migration that could not
	// be safely resolved, and warnings about any possibly-risky assumptions made
	// in the upgrade process.
	Diagnostics   []*Diagnostic `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpgradeResourceState_Response) Reset() {
	*x = UpgradeResourceState_Response{}
	mi := &file_tfplugin6_proto_msgTypes[55]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpgradeResourceState_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeResourceState_Response) ProtoMessage() {}

func (x *UpgradeResourceState_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[55]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeResourceState_Response.ProtoReflect.Descriptor instead.
func (*UpgradeResourceState_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{14, 1}
}

func (x *UpgradeResourceState_Response) GetUpgradedState() *DynamicValue {
	if x != nil {
		return x.UpgradedState
	}
	return nil
}

func (x *UpgradeResourceState_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type ValidateResourceConfig_Request struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	TypeName           string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Config             *DynamicValue          `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	ClientCapabilities *ClientCapabilities    `protobuf:"bytes,3,opt,name=client_capabilities,json=clientCapabilities,proto3" json:"client_capabilities,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *ValidateResourceConfig_Request) Reset() {
	*x = ValidateResourceConfig_Request{}
	mi := &file_tfplugin6_proto_msgTypes[56]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateResourceConfig_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateResourceConfig_Request) ProtoMessage() {}

func (x *ValidateResourceConfig_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[56]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateResourceConfig_Request.ProtoReflect.Descriptor instead.
func (*ValidateResourceConfig_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{15, 0}
}

func (x *ValidateResourceConfig_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ValidateResourceConfig_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *ValidateResourceConfig_Request) GetClientCapabilities() *ClientCapabilities {
	if x != nil {
		return x.ClientCapabilities
	}
	return nil
}

type ValidateResourceConfig_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateResourceConfig_Response) Reset() {
	*x = ValidateResourceConfig_Response{}
	mi := &file_tfplugin6_proto_msgTypes[57]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateResourceConfig_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateResourceConfig_Response) ProtoMessage() {}

func (x *ValidateResourceConfig_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[57]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateResourceConfig_Response.ProtoReflect.Descriptor instead.
func (*ValidateResourceConfig_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{15, 1}
}

func (x *ValidateResourceConfig_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type ValidateDataResourceConfig_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Config        *DynamicValue          `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateDataResourceConfig_Request) Reset() {
	*x = ValidateDataResourceConfig_Request{}
	mi := &file_tfplugin6_proto_msgTypes[58]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateDataResourceConfig_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateDataResourceConfig_Request) ProtoMessage() {}

func (x *ValidateDataResourceConfig_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[58]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateDataResourceConfig_Request.ProtoReflect.Descriptor instead.
func (*ValidateDataResourceConfig_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{16, 0}
}

func (x *ValidateDataResourceConfig_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ValidateDataResourceConfig_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

type ValidateDataResourceConfig_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateDataResourceConfig_Response) Reset() {
	*x = ValidateDataResourceConfig_Response{}
	mi := &file_tfplugin6_proto_msgTypes[59]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateDataResourceConfig_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateDataResourceConfig_Response) ProtoMessage() {}

func (x *ValidateDataResourceConfig_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[59]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateDataResourceConfig_Response.ProtoReflect.Descriptor instead.
func (*ValidateDataResourceConfig_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{16, 1}
}

func (x *ValidateDataResourceConfig_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type ConfigureProvider_Request struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	TerraformVersion   string                 `protobuf:"bytes,1,opt,name=terraform_version,json=terraformVersion,proto3" json:"terraform_version,omitempty"`
	Config             *DynamicValue          `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	ClientCapabilities *ClientCapabilities    `protobuf:"bytes,3,opt,name=client_capabilities,json=clientCapabilities,proto3" json:"client_capabilities,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *ConfigureProvider_Request) Reset() {
	*x = ConfigureProvider_Request{}
	mi := &file_tfplugin6_proto_msgTypes[60]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConfigureProvider_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigureProvider_Request) ProtoMessage() {}

func (x *ConfigureProvider_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[60]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigureProvider_Request.ProtoReflect.Descriptor instead.
func (*ConfigureProvider_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{17, 0}
}

func (x *ConfigureProvider_Request) GetTerraformVersion() string {
	if x != nil {
		return x.TerraformVersion
	}
	return ""
}

func (x *ConfigureProvider_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *ConfigureProvider_Request) GetClientCapabilities() *ClientCapabilities {
	if x != nil {
		return x.ClientCapabilities
	}
	return nil
}

type ConfigureProvider_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ConfigureProvider_Response) Reset() {
	*x = ConfigureProvider_Response{}
	mi := &file_tfplugin6_proto_msgTypes[61]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConfigureProvider_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigureProvider_Response) ProtoMessage() {}

func (x *ConfigureProvider_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[61]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigureProvider_Response.ProtoReflect.Descriptor instead.
func (*ConfigureProvider_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{17, 1}
}

func (x *ConfigureProvider_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

// Request is the message that is sent to the provider during the
// ReadResource RPC.
//
// This message intentionally does not include configuration data as any
// configuration-based or configuration-conditional changes should occur
// during the PlanResourceChange RPC. Additionally, the configuration is
// not guaranteed to be wholly known nor match the given prior state, which
// could lead to unexpected provider behaviors for practitioners.
type ReadResource_Request struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	TypeName           string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	CurrentState       *DynamicValue          `protobuf:"bytes,2,opt,name=current_state,json=currentState,proto3" json:"current_state,omitempty"`
	Private            []byte                 `protobuf:"bytes,3,opt,name=private,proto3" json:"private,omitempty"`
	ProviderMeta       *DynamicValue          `protobuf:"bytes,4,opt,name=provider_meta,json=providerMeta,proto3" json:"provider_meta,omitempty"`
	ClientCapabilities *ClientCapabilities    `protobuf:"bytes,5,opt,name=client_capabilities,json=clientCapabilities,proto3" json:"client_capabilities,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *ReadResource_Request) Reset() {
	*x = ReadResource_Request{}
	mi := &file_tfplugin6_proto_msgTypes[62]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadResource_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadResource_Request) ProtoMessage() {}

func (x *ReadResource_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[62]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadResource_Request.ProtoReflect.Descriptor instead.
func (*ReadResource_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{18, 0}
}

func (x *ReadResource_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ReadResource_Request) GetCurrentState() *DynamicValue {
	if x != nil {
		return x.CurrentState
	}
	return nil
}

func (x *ReadResource_Request) GetPrivate() []byte {
	if x != nil {
		return x.Private
	}
	return nil
}

func (x *ReadResource_Request) GetProviderMeta() *DynamicValue {
	if x != nil {
		return x.ProviderMeta
	}
	return nil
}

func (x *ReadResource_Request) GetClientCapabilities() *ClientCapabilities {
	if x != nil {
		return x.ClientCapabilities
	}
	return nil
}

type ReadResource_Response struct {
	state       protoimpl.MessageState `protogen:"open.v1"`
	NewState    *DynamicValue          `protobuf:"bytes,1,opt,name=new_state,json=newState,proto3" json:"new_state,omitempty"`
	Diagnostics []*Diagnostic          `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	Private     []byte                 `protobuf:"bytes,3,opt,name=private,proto3" json:"private,omitempty"`
	// deferred is set if the provider is deferring the change. If set the caller
	// needs to handle the deferral.
	Deferred      *Deferred `protobuf:"bytes,4,opt,name=deferred,proto3" json:"deferred,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReadResource_Response) Reset() {
	*x = ReadResource_Response{}
	mi := &file_tfplugin6_proto_msgTypes[63]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadResource_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadResource_Response) ProtoMessage() {}

func (x *ReadResource_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[63]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadResource_Response.ProtoReflect.Descriptor instead.
func (*ReadResource_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{18, 1}
}

func (x *ReadResource_Response) GetNewState() *DynamicValue {
	if x != nil {
		return x.NewState
	}
	return nil
}

func (x *ReadResource_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *ReadResource_Response) GetPrivate() []byte {
	if x != nil {
		return x.Private
	}
	return nil
}

func (x *ReadResource_Response) GetDeferred() *Deferred {
	if x != nil {
		return x.Deferred
	}
	return nil
}

type PlanResourceChange_Request struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	TypeName           string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	PriorState         *DynamicValue          `protobuf:"bytes,2,opt,name=prior_state,json=priorState,proto3" json:"prior_state,omitempty"`
	ProposedNewState   *DynamicValue          `protobuf:"bytes,3,opt,name=proposed_new_state,json=proposedNewState,proto3" json:"proposed_new_state,omitempty"`
	Config             *DynamicValue          `protobuf:"bytes,4,opt,name=config,proto3" json:"config,omitempty"`
	PriorPrivate       []byte                 `protobuf:"bytes,5,opt,name=prior_private,json=priorPrivate,proto3" json:"prior_private,omitempty"`
	ProviderMeta       *DynamicValue          `protobuf:"bytes,6,opt,name=provider_meta,json=providerMeta,proto3" json:"provider_meta,omitempty"`
	ClientCapabilities *ClientCapabilities    `protobuf:"bytes,7,opt,name=client_capabilities,json=clientCapabilities,proto3" json:"client_capabilities,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *PlanResourceChange_Request) Reset() {
	*x = PlanResourceChange_Request{}
	mi := &file_tfplugin6_proto_msgTypes[64]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlanResourceChange_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlanResourceChange_Request) ProtoMessage() {}

func (x *PlanResourceChange_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[64]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlanResourceChange_Request.ProtoReflect.Descriptor instead.
func (*PlanResourceChange_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{19, 0}
}

func (x *PlanResourceChange_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *PlanResourceChange_Request) GetPriorState() *DynamicValue {
	if x != nil {
		return x.PriorState
	}
	return nil
}

func (x *PlanResourceChange_Request) GetProposedNewState() *DynamicValue {
	if x != nil {
		return x.ProposedNewState
	}
	return nil
}

func (x *PlanResourceChange_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *PlanResourceChange_Request) GetPriorPrivate() []byte {
	if x != nil {
		return x.PriorPrivate
	}
	return nil
}

func (x *PlanResourceChange_Request) GetProviderMeta() *DynamicValue {
	if x != nil {
		return x.ProviderMeta
	}
	return nil
}

func (x *PlanResourceChange_Request) GetClientCapabilities() *ClientCapabilities {
	if x != nil {
		return x.ClientCapabilities
	}
	return nil
}

type PlanResourceChange_Response struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	PlannedState    *DynamicValue          `protobuf:"bytes,1,opt,name=planned_state,json=plannedState,proto3" json:"planned_state,omitempty"`
	RequiresReplace []*AttributePath       `protobuf:"bytes,2,rep,name=requires_replace,json=requiresReplace,proto3" json:"requires_replace,omitempty"`
	PlannedPrivate  []byte                 `protobuf:"bytes,3,opt,name=planned_private,json=plannedPrivate,proto3" json:"planned_private,omitempty"`
	Diagnostics     []*Diagnostic          `protobuf:"bytes,4,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	// This may be set only by the helper/schema "SDK" in the main Terraform
	// repository, to request that Terraform Core >=0.12 permit additional
	// inconsistencies that can result from the legacy SDK type system
	// and its imprecise mapping to the >=0.12 type system.
	// The change in behavior implied by this flag makes sense only for the
	// specific details of the legacy SDK type system, and are not a general
	// mechanism to avoid proper type handling in providers.
	//
	//	====              DO NOT USE THIS              ====
	//	==== THIS MUST BE LEFT UNSET IN ALL OTHER SDKS ====
	//	====              DO NOT USE THIS              ====
	LegacyTypeSystem bool `protobuf:"varint,5,opt,name=legacy_type_system,json=legacyTypeSystem,proto3" json:"legacy_type_system,omitempty"`
	// deferred is set if the provider is deferring the change. If set the caller
	// needs to handle the deferral.
	Deferred      *Deferred `protobuf:"bytes,6,opt,name=deferred,proto3" json:"deferred,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PlanResourceChange_Response) Reset() {
	*x = PlanResourceChange_Response{}
	mi := &file_tfplugin6_proto_msgTypes[65]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlanResourceChange_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlanResourceChange_Response) ProtoMessage() {}

func (x *PlanResourceChange_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[65]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlanResourceChange_Response.ProtoReflect.Descriptor instead.
func (*PlanResourceChange_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{19, 1}
}

func (x *PlanResourceChange_Response) GetPlannedState() *DynamicValue {
	if x != nil {
		return x.PlannedState
	}
	return nil
}

func (x *PlanResourceChange_Response) GetRequiresReplace() []*AttributePath {
	if x != nil {
		return x.RequiresReplace
	}
	return nil
}

func (x *PlanResourceChange_Response) GetPlannedPrivate() []byte {
	if x != nil {
		return x.PlannedPrivate
	}
	return nil
}

func (x *PlanResourceChange_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *PlanResourceChange_Response) GetLegacyTypeSystem() bool {
	if x != nil {
		return x.LegacyTypeSystem
	}
	return false
}

func (x *PlanResourceChange_Response) GetDeferred() *Deferred {
	if x != nil {
		return x.Deferred
	}
	return nil
}

type ApplyResourceChange_Request struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	TypeName       string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	PriorState     *DynamicValue          `protobuf:"bytes,2,opt,name=prior_state,json=priorState,proto3" json:"prior_state,omitempty"`
	PlannedState   *DynamicValue          `protobuf:"bytes,3,opt,name=planned_state,json=plannedState,proto3" json:"planned_state,omitempty"`
	Config         *DynamicValue          `protobuf:"bytes,4,opt,name=config,proto3" json:"config,omitempty"`
	PlannedPrivate []byte                 `protobuf:"bytes,5,opt,name=planned_private,json=plannedPrivate,proto3" json:"planned_private,omitempty"`
	ProviderMeta   *DynamicValue          `protobuf:"bytes,6,opt,name=provider_meta,json=providerMeta,proto3" json:"provider_meta,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *ApplyResourceChange_Request) Reset() {
	*x = ApplyResourceChange_Request{}
	mi := &file_tfplugin6_proto_msgTypes[66]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApplyResourceChange_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyResourceChange_Request) ProtoMessage() {}

func (x *ApplyResourceChange_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[66]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyResourceChange_Request.ProtoReflect.Descriptor instead.
func (*ApplyResourceChange_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{20, 0}
}

func (x *ApplyResourceChange_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ApplyResourceChange_Request) GetPriorState() *DynamicValue {
	if x != nil {
		return x.PriorState
	}
	return nil
}

func (x *ApplyResourceChange_Request) GetPlannedState() *DynamicValue {
	if x != nil {
		return x.PlannedState
	}
	return nil
}

func (x *ApplyResourceChange_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *ApplyResourceChange_Request) GetPlannedPrivate() []byte {
	if x != nil {
		return x.PlannedPrivate
	}
	return nil
}

func (x *ApplyResourceChange_Request) GetProviderMeta() *DynamicValue {
	if x != nil {
		return x.ProviderMeta
	}
	return nil
}

type ApplyResourceChange_Response struct {
	state       protoimpl.MessageState `protogen:"open.v1"`
	NewState    *DynamicValue          `protobuf:"bytes,1,opt,name=new_state,json=newState,proto3" json:"new_state,omitempty"`
	Private     []byte                 `protobuf:"bytes,2,opt,name=private,proto3" json:"private,omitempty"`
	Diagnostics []*Diagnostic          `protobuf:"bytes,3,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	// This may be set only by the helper/schema "SDK" in the main Terraform
	// repository, to request that Terraform Core >=0.12 permit additional
	// inconsistencies that can result from the legacy SDK type system
	// and its imprecise mapping to the >=0.12 type system.
	// The change in behavior implied by this flag makes sense only for the
	// specific details of the legacy SDK type system, and are not a general
	// mechanism to avoid proper type handling in providers.
	//
	//	====              DO NOT USE THIS              ====
	//	==== THIS MUST BE LEFT UNSET IN ALL OTHER SDKS ====
	//	====              DO NOT USE THIS              ====
	LegacyTypeSystem bool `protobuf:"varint,4,opt,name=legacy_type_system,json=legacyTypeSystem,proto3" json:"legacy_type_system,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *ApplyResourceChange_Response) Reset() {
	*x = ApplyResourceChange_Response{}
	mi := &file_tfplugin6_proto_msgTypes[67]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApplyResourceChange_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyResourceChange_Response) ProtoMessage() {}

func (x *ApplyResourceChange_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[67]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyResourceChange_Response.ProtoReflect.Descriptor instead.
func (*ApplyResourceChange_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{20, 1}
}

func (x *ApplyResourceChange_Response) GetNewState() *DynamicValue {
	if x != nil {
		return x.NewState
	}
	return nil
}

func (x *ApplyResourceChange_Response) GetPrivate() []byte {
	if x != nil {
		return x.Private
	}
	return nil
}

func (x *ApplyResourceChange_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *ApplyResourceChange_Response) GetLegacyTypeSystem() bool {
	if x != nil {
		return x.LegacyTypeSystem
	}
	return false
}

type ImportResourceState_Request struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	TypeName           string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Id                 string                 `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	ClientCapabilities *ClientCapabilities    `protobuf:"bytes,3,opt,name=client_capabilities,json=clientCapabilities,proto3" json:"client_capabilities,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *ImportResourceState_Request) Reset() {
	*x = ImportResourceState_Request{}
	mi := &file_tfplugin6_proto_msgTypes[68]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportResourceState_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportResourceState_Request) ProtoMessage() {}

func (x *ImportResourceState_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[68]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportResourceState_Request.ProtoReflect.Descriptor instead.
func (*ImportResourceState_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{21, 0}
}

func (x *ImportResourceState_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ImportResourceState_Request) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ImportResourceState_Request) GetClientCapabilities() *ClientCapabilities {
	if x != nil {
		return x.ClientCapabilities
	}
	return nil
}

type ImportResourceState_ImportedResource struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	State         *DynamicValue          `protobuf:"bytes,2,opt,name=state,proto3" json:"state,omitempty"`
	Private       []byte                 `protobuf:"bytes,3,opt,name=private,proto3" json:"private,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ImportResourceState_ImportedResource) Reset() {
	*x = ImportResourceState_ImportedResource{}
	mi := &file_tfplugin6_proto_msgTypes[69]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportResourceState_ImportedResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportResourceState_ImportedResource) ProtoMessage() {}

func (x *ImportResourceState_ImportedResource) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[69]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportResourceState_ImportedResource.ProtoReflect.Descriptor instead.
func (*ImportResourceState_ImportedResource) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{21, 1}
}

func (x *ImportResourceState_ImportedResource) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ImportResourceState_ImportedResource) GetState() *DynamicValue {
	if x != nil {
		return x.State
	}
	return nil
}

func (x *ImportResourceState_ImportedResource) GetPrivate() []byte {
	if x != nil {
		return x.Private
	}
	return nil
}

type ImportResourceState_Response struct {
	state             protoimpl.MessageState                  `protogen:"open.v1"`
	ImportedResources []*ImportResourceState_ImportedResource `protobuf:"bytes,1,rep,name=imported_resources,json=importedResources,proto3" json:"imported_resources,omitempty"`
	Diagnostics       []*Diagnostic                           `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	// deferred is set if the provider is deferring the change. If set the caller
	// needs to handle the deferral.
	Deferred      *Deferred `protobuf:"bytes,3,opt,name=deferred,proto3" json:"deferred,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ImportResourceState_Response) Reset() {
	*x = ImportResourceState_Response{}
	mi := &file_tfplugin6_proto_msgTypes[70]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportResourceState_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportResourceState_Response) ProtoMessage() {}

func (x *ImportResourceState_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[70]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportResourceState_Response.ProtoReflect.Descriptor instead.
func (*ImportResourceState_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{21, 2}
}

func (x *ImportResourceState_Response) GetImportedResources() []*ImportResourceState_ImportedResource {
	if x != nil {
		return x.ImportedResources
	}
	return nil
}

func (x *ImportResourceState_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *ImportResourceState_Response) GetDeferred() *Deferred {
	if x != nil {
		return x.Deferred
	}
	return nil
}

type MoveResourceState_Request struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The address of the provider the resource is being moved from.
	SourceProviderAddress string `protobuf:"bytes,1,opt,name=source_provider_address,json=sourceProviderAddress,proto3" json:"source_provider_address,omitempty"`
	// The resource type that the resource is being moved from.
	SourceTypeName string `protobuf:"bytes,2,opt,name=source_type_name,json=sourceTypeName,proto3" json:"source_type_name,omitempty"`
	// The schema version of the resource type that the resource is being
	// moved from.
	SourceSchemaVersion int64 `protobuf:"varint,3,opt,name=source_schema_version,json=sourceSchemaVersion,proto3" json:"source_schema_version,omitempty"`
	// The raw state of the resource being moved. Only the json field is
	// populated, as there should be no legacy providers using the flatmap
	// format that support newly introduced RPCs.
	SourceState *RawState `protobuf:"bytes,4,opt,name=source_state,json=sourceState,proto3" json:"source_state,omitempty"`
	// The resource type that the resource is being moved to.
	TargetTypeName string `protobuf:"bytes,5,opt,name=target_type_name,json=targetTypeName,proto3" json:"target_type_name,omitempty"`
	// The private state of the resource being moved.
	SourcePrivate []byte `protobuf:"bytes,6,opt,name=source_private,json=sourcePrivate,proto3" json:"source_private,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MoveResourceState_Request) Reset() {
	*x = MoveResourceState_Request{}
	mi := &file_tfplugin6_proto_msgTypes[71]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MoveResourceState_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveResourceState_Request) ProtoMessage() {}

func (x *MoveResourceState_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[71]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveResourceState_Request.ProtoReflect.Descriptor instead.
func (*MoveResourceState_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{22, 0}
}

func (x *MoveResourceState_Request) GetSourceProviderAddress() string {
	if x != nil {
		return x.SourceProviderAddress
	}
	return ""
}

func (x *MoveResourceState_Request) GetSourceTypeName() string {
	if x != nil {
		return x.SourceTypeName
	}
	return ""
}

func (x *MoveResourceState_Request) GetSourceSchemaVersion() int64 {
	if x != nil {
		return x.SourceSchemaVersion
	}
	return 0
}

func (x *MoveResourceState_Request) GetSourceState() *RawState {
	if x != nil {
		return x.SourceState
	}
	return nil
}

func (x *MoveResourceState_Request) GetTargetTypeName() string {
	if x != nil {
		return x.TargetTypeName
	}
	return ""
}

func (x *MoveResourceState_Request) GetSourcePrivate() []byte {
	if x != nil {
		return x.SourcePrivate
	}
	return nil
}

type MoveResourceState_Response struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The state of the resource after it has been moved.
	TargetState *DynamicValue `protobuf:"bytes,1,opt,name=target_state,json=targetState,proto3" json:"target_state,omitempty"`
	// Any diagnostics that occurred during the move.
	Diagnostics []*Diagnostic `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	// The private state of the resource after it has been moved.
	TargetPrivate []byte `protobuf:"bytes,3,opt,name=target_private,json=targetPrivate,proto3" json:"target_private,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MoveResourceState_Response) Reset() {
	*x = MoveResourceState_Response{}
	mi := &file_tfplugin6_proto_msgTypes[72]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MoveResourceState_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveResourceState_Response) ProtoMessage() {}

func (x *MoveResourceState_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[72]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveResourceState_Response.ProtoReflect.Descriptor instead.
func (*MoveResourceState_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{22, 1}
}

func (x *MoveResourceState_Response) GetTargetState() *DynamicValue {
	if x != nil {
		return x.TargetState
	}
	return nil
}

func (x *MoveResourceState_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *MoveResourceState_Response) GetTargetPrivate() []byte {
	if x != nil {
		return x.TargetPrivate
	}
	return nil
}

type ReadDataSource_Request struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	TypeName           string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Config             *DynamicValue          `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	ProviderMeta       *DynamicValue          `protobuf:"bytes,3,opt,name=provider_meta,json=providerMeta,proto3" json:"provider_meta,omitempty"`
	ClientCapabilities *ClientCapabilities    `protobuf:"bytes,4,opt,name=client_capabilities,json=clientCapabilities,proto3" json:"client_capabilities,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *ReadDataSource_Request) Reset() {
	*x = ReadDataSource_Request{}
	mi := &file_tfplugin6_proto_msgTypes[73]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadDataSource_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadDataSource_Request) ProtoMessage() {}

func (x *ReadDataSource_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[73]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadDataSource_Request.ProtoReflect.Descriptor instead.
func (*ReadDataSource_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{23, 0}
}

func (x *ReadDataSource_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ReadDataSource_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *ReadDataSource_Request) GetProviderMeta() *DynamicValue {
	if x != nil {
		return x.ProviderMeta
	}
	return nil
}

func (x *ReadDataSource_Request) GetClientCapabilities() *ClientCapabilities {
	if x != nil {
		return x.ClientCapabilities
	}
	return nil
}

type ReadDataSource_Response struct {
	state       protoimpl.MessageState `protogen:"open.v1"`
	State       *DynamicValue          `protobuf:"bytes,1,opt,name=state,proto3" json:"state,omitempty"`
	Diagnostics []*Diagnostic          `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	// deferred is set if the provider is deferring the change. If set the caller
	// needs to handle the deferral.
	Deferred      *Deferred `protobuf:"bytes,3,opt,name=deferred,proto3" json:"deferred,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReadDataSource_Response) Reset() {
	*x = ReadDataSource_Response{}
	mi := &file_tfplugin6_proto_msgTypes[74]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadDataSource_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadDataSource_Response) ProtoMessage() {}

func (x *ReadDataSource_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[74]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadDataSource_Response.ProtoReflect.Descriptor instead.
func (*ReadDataSource_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{23, 1}
}

func (x *ReadDataSource_Response) GetState() *DynamicValue {
	if x != nil {
		return x.State
	}
	return nil
}

func (x *ReadDataSource_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *ReadDataSource_Response) GetDeferred() *Deferred {
	if x != nil {
		return x.Deferred
	}
	return nil
}

type GetFunctions_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetFunctions_Request) Reset() {
	*x = GetFunctions_Request{}
	mi := &file_tfplugin6_proto_msgTypes[75]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetFunctions_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFunctions_Request) ProtoMessage() {}

func (x *GetFunctions_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[75]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFunctions_Request.ProtoReflect.Descriptor instead.
func (*GetFunctions_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{24, 0}
}

type GetFunctions_Response struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// functions is a mapping of function names to definitions.
	Functions map[string]*Function `protobuf:"bytes,1,rep,name=functions,proto3" json:"functions,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// diagnostics is any warnings or errors.
	Diagnostics   []*Diagnostic `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetFunctions_Response) Reset() {
	*x = GetFunctions_Response{}
	mi := &file_tfplugin6_proto_msgTypes[76]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetFunctions_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFunctions_Response) ProtoMessage() {}

func (x *GetFunctions_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[76]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFunctions_Response.ProtoReflect.Descriptor instead.
func (*GetFunctions_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{24, 1}
}

func (x *GetFunctions_Response) GetFunctions() map[string]*Function {
	if x != nil {
		return x.Functions
	}
	return nil
}

func (x *GetFunctions_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type CallFunction_Request struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// name is the name of the function being called.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// arguments is the data of each function argument value.
	Arguments     []*DynamicValue `protobuf:"bytes,2,rep,name=arguments,proto3" json:"arguments,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CallFunction_Request) Reset() {
	*x = CallFunction_Request{}
	mi := &file_tfplugin6_proto_msgTypes[78]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CallFunction_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CallFunction_Request) ProtoMessage() {}

func (x *CallFunction_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[78]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CallFunction_Request.ProtoReflect.Descriptor instead.
func (*CallFunction_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{25, 0}
}

func (x *CallFunction_Request) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CallFunction_Request) GetArguments() []*DynamicValue {
	if x != nil {
		return x.Arguments
	}
	return nil
}

type CallFunction_Response struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// result is result value after running the function logic.
	Result *DynamicValue `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
	// error is any error from the function logic.
	Error         *FunctionError `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CallFunction_Response) Reset() {
	*x = CallFunction_Response{}
	mi := &file_tfplugin6_proto_msgTypes[79]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CallFunction_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CallFunction_Response) ProtoMessage() {}

func (x *CallFunction_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[79]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CallFunction_Response.ProtoReflect.Descriptor instead.
func (*CallFunction_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{25, 1}
}

func (x *CallFunction_Response) GetResult() *DynamicValue {
	if x != nil {
		return x.Result
	}
	return nil
}

func (x *CallFunction_Response) GetError() *FunctionError {
	if x != nil {
		return x.Error
	}
	return nil
}

type ValidateEphemeralResourceConfig_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Config        *DynamicValue          `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateEphemeralResourceConfig_Request) Reset() {
	*x = ValidateEphemeralResourceConfig_Request{}
	mi := &file_tfplugin6_proto_msgTypes[80]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateEphemeralResourceConfig_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateEphemeralResourceConfig_Request) ProtoMessage() {}

func (x *ValidateEphemeralResourceConfig_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[80]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateEphemeralResourceConfig_Request.ProtoReflect.Descriptor instead.
func (*ValidateEphemeralResourceConfig_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{26, 0}
}

func (x *ValidateEphemeralResourceConfig_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ValidateEphemeralResourceConfig_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

type ValidateEphemeralResourceConfig_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateEphemeralResourceConfig_Response) Reset() {
	*x = ValidateEphemeralResourceConfig_Response{}
	mi := &file_tfplugin6_proto_msgTypes[81]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateEphemeralResourceConfig_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateEphemeralResourceConfig_Response) ProtoMessage() {}

func (x *ValidateEphemeralResourceConfig_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[81]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateEphemeralResourceConfig_Response.ProtoReflect.Descriptor instead.
func (*ValidateEphemeralResourceConfig_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{26, 1}
}

func (x *ValidateEphemeralResourceConfig_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type OpenEphemeralResource_Request struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	TypeName           string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Config             *DynamicValue          `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	ClientCapabilities *ClientCapabilities    `protobuf:"bytes,3,opt,name=client_capabilities,json=clientCapabilities,proto3" json:"client_capabilities,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *OpenEphemeralResource_Request) Reset() {
	*x = OpenEphemeralResource_Request{}
	mi := &file_tfplugin6_proto_msgTypes[82]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpenEphemeralResource_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenEphemeralResource_Request) ProtoMessage() {}

func (x *OpenEphemeralResource_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[82]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenEphemeralResource_Request.ProtoReflect.Descriptor instead.
func (*OpenEphemeralResource_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{27, 0}
}

func (x *OpenEphemeralResource_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *OpenEphemeralResource_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *OpenEphemeralResource_Request) GetClientCapabilities() *ClientCapabilities {
	if x != nil {
		return x.ClientCapabilities
	}
	return nil
}

type OpenEphemeralResource_Response struct {
	state       protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	RenewAt     *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=renew_at,json=renewAt,proto3,oneof" json:"renew_at,omitempty"`
	Result      *DynamicValue          `protobuf:"bytes,3,opt,name=result,proto3" json:"result,omitempty"`
	Private     []byte                 `protobuf:"bytes,4,opt,name=private,proto3,oneof" json:"private,omitempty"`
	// deferred is set if the provider is deferring the change. If set the caller
	// needs to handle the deferral.
	Deferred      *Deferred `protobuf:"bytes,5,opt,name=deferred,proto3" json:"deferred,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OpenEphemeralResource_Response) Reset() {
	*x = OpenEphemeralResource_Response{}
	mi := &file_tfplugin6_proto_msgTypes[83]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpenEphemeralResource_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenEphemeralResource_Response) ProtoMessage() {}

func (x *OpenEphemeralResource_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[83]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenEphemeralResource_Response.ProtoReflect.Descriptor instead.
func (*OpenEphemeralResource_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{27, 1}
}

func (x *OpenEphemeralResource_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *OpenEphemeralResource_Response) GetRenewAt() *timestamppb.Timestamp {
	if x != nil {
		return x.RenewAt
	}
	return nil
}

func (x *OpenEphemeralResource_Response) GetResult() *DynamicValue {
	if x != nil {
		return x.Result
	}
	return nil
}

func (x *OpenEphemeralResource_Response) GetPrivate() []byte {
	if x != nil {
		return x.Private
	}
	return nil
}

func (x *OpenEphemeralResource_Response) GetDeferred() *Deferred {
	if x != nil {
		return x.Deferred
	}
	return nil
}

type RenewEphemeralResource_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Private       []byte                 `protobuf:"bytes,2,opt,name=private,proto3,oneof" json:"private,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RenewEphemeralResource_Request) Reset() {
	*x = RenewEphemeralResource_Request{}
	mi := &file_tfplugin6_proto_msgTypes[84]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RenewEphemeralResource_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenewEphemeralResource_Request) ProtoMessage() {}

func (x *RenewEphemeralResource_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[84]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RenewEphemeralResource_Request.ProtoReflect.Descriptor instead.
func (*RenewEphemeralResource_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{28, 0}
}

func (x *RenewEphemeralResource_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *RenewEphemeralResource_Request) GetPrivate() []byte {
	if x != nil {
		return x.Private
	}
	return nil
}

type RenewEphemeralResource_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	RenewAt       *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=renew_at,json=renewAt,proto3,oneof" json:"renew_at,omitempty"`
	Private       []byte                 `protobuf:"bytes,3,opt,name=private,proto3,oneof" json:"private,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RenewEphemeralResource_Response) Reset() {
	*x = RenewEphemeralResource_Response{}
	mi := &file_tfplugin6_proto_msgTypes[85]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RenewEphemeralResource_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenewEphemeralResource_Response) ProtoMessage() {}

func (x *RenewEphemeralResource_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[85]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RenewEphemeralResource_Response.ProtoReflect.Descriptor instead.
func (*RenewEphemeralResource_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{28, 1}
}

func (x *RenewEphemeralResource_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *RenewEphemeralResource_Response) GetRenewAt() *timestamppb.Timestamp {
	if x != nil {
		return x.RenewAt
	}
	return nil
}

func (x *RenewEphemeralResource_Response) GetPrivate() []byte {
	if x != nil {
		return x.Private
	}
	return nil
}

type CloseEphemeralResource_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Private       []byte                 `protobuf:"bytes,2,opt,name=private,proto3,oneof" json:"private,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CloseEphemeralResource_Request) Reset() {
	*x = CloseEphemeralResource_Request{}
	mi := &file_tfplugin6_proto_msgTypes[86]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloseEphemeralResource_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseEphemeralResource_Request) ProtoMessage() {}

func (x *CloseEphemeralResource_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[86]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseEphemeralResource_Request.ProtoReflect.Descriptor instead.
func (*CloseEphemeralResource_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{29, 0}
}

func (x *CloseEphemeralResource_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *CloseEphemeralResource_Request) GetPrivate() []byte {
	if x != nil {
		return x.Private
	}
	return nil
}

type CloseEphemeralResource_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CloseEphemeralResource_Response) Reset() {
	*x = CloseEphemeralResource_Response{}
	mi := &file_tfplugin6_proto_msgTypes[87]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloseEphemeralResource_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseEphemeralResource_Response) ProtoMessage() {}

func (x *CloseEphemeralResource_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin6_proto_msgTypes[87]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseEphemeralResource_Response.ProtoReflect.Descriptor instead.
func (*CloseEphemeralResource_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin6_proto_rawDescGZIP(), []int{29, 1}
}

func (x *CloseEphemeralResource_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

var File_tfplugin6_proto protoreflect.FileDescriptor

var file_tfplugin6_proto_rawDesc = []byte{
	0x0a, 0x0f, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x09, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x3c, 0x0a,
	0x0c, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x18, 0x0a,
	0x07, 0x6d, 0x73, 0x67, 0x70, 0x61, 0x63, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07,
	0x6d, 0x73, 0x67, 0x70, 0x61, 0x63, 0x6b, 0x12, 0x12, 0x0a, 0x04, 0x6a, 0x73, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x6a, 0x73, 0x6f, 0x6e, 0x22, 0xe3, 0x01, 0x0a, 0x0a,
	0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x12, 0x3a, 0x0a, 0x08, 0x73, 0x65,
	0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x74,
	0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73,
	0x74, 0x69, 0x63, 0x2e, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x52, 0x08, 0x73, 0x65,
	0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79,
	0x12, 0x16, 0x0a, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x36, 0x0a, 0x09, 0x61, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x74, 0x66,
	0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x50, 0x61, 0x74, 0x68, 0x52, 0x09, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x22, 0x2f, 0x0a, 0x08, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x0b, 0x0a, 0x07,
	0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52,
	0x4f, 0x52, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x57, 0x41, 0x52, 0x4e, 0x49, 0x4e, 0x47, 0x10,
	0x02, 0x22, 0x6b, 0x0a, 0x0d, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x30, 0x0a, 0x11, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x48, 0x00, 0x52, 0x10, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x67,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x66, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0xdc,
	0x01, 0x0a, 0x0d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x50, 0x61, 0x74, 0x68,
	0x12, 0x33, 0x0a, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1d, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x50, 0x61, 0x74, 0x68, 0x2e, 0x53, 0x74, 0x65, 0x70, 0x52, 0x05,
	0x73, 0x74, 0x65, 0x70, 0x73, 0x1a, 0x95, 0x01, 0x0a, 0x04, 0x53, 0x74, 0x65, 0x70, 0x12, 0x27,
	0x0a, 0x0e, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0d, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2e, 0x0a, 0x12, 0x65, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x10, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4b, 0x65,
	0x79, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x28, 0x0a, 0x0f, 0x65, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03,
	0x48, 0x00, 0x52, 0x0d, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x49, 0x6e,
	0x74, 0x42, 0x0a, 0x0a, 0x08, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x22, 0x3b, 0x0a,
	0x0c, 0x53, 0x74, 0x6f, 0x70, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x1a, 0x09, 0x0a,
	0x07, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x20, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x96, 0x01, 0x0a, 0x08, 0x52,
	0x61, 0x77, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6a, 0x73, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x6a, 0x73, 0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x07, 0x66,
	0x6c, 0x61, 0x74, 0x6d, 0x61, 0x70, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x74,
	0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x52, 0x61, 0x77, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x2e, 0x46, 0x6c, 0x61, 0x74, 0x6d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07,
	0x66, 0x6c, 0x61, 0x74, 0x6d, 0x61, 0x70, 0x1a, 0x3a, 0x0a, 0x0c, 0x46, 0x6c, 0x61, 0x74, 0x6d,
	0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0xb4, 0x0a, 0x0a, 0x06, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x18,
	0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2d, 0x0a, 0x05, 0x62, 0x6c, 0x6f, 0x63,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x36, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x42, 0x6c, 0x6f, 0x63, 0x6b,
	0x52, 0x05, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x1a, 0xa2, 0x02, 0x0a, 0x05, 0x42, 0x6c, 0x6f, 0x63,
	0x6b, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0a, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x52, 0x0a, 0x61, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x3e, 0x0a, 0x0b, 0x62, 0x6c, 0x6f, 0x63,
	0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e,
	0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x2e, 0x4e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x0a, 0x62, 0x6c,
	0x6f, 0x63, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x10, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x15, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36,
	0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x4b, 0x69, 0x6e, 0x64, 0x52, 0x0f, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x69, 0x6e, 0x64, 0x12, 0x1e, 0x0a, 0x0a,
	0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x1a, 0x83, 0x03, 0x0a,
	0x09, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x39, 0x0a, 0x0b, 0x6e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x36, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x52, 0x0a, 0x6e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1a, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x63, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x65, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76,
	0x65, 0x12, 0x40, 0x0a, 0x10, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x15, 0x2e, 0x74, 0x66,
	0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x4b, 0x69,
	0x6e, 0x64, 0x52, 0x0f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b,
	0x69, 0x6e, 0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65,
	0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61,
	0x74, 0x65, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c,
	0x79, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x77, 0x72, 0x69, 0x74, 0x65, 0x4f, 0x6e,
	0x6c, 0x79, 0x1a, 0xa7, 0x02, 0x0a, 0x0b, 0x4e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x42, 0x6c, 0x6f,
	0x63, 0x6b, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x79, 0x70, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x2d, 0x0a, 0x05, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x2e, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x05, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x43,
	0x0a, 0x07, 0x6e, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x29, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x2e, 0x4e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x2e, 0x4e,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x07, 0x6e, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x69, 0x6e, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x6d, 0x69, 0x6e, 0x49, 0x74, 0x65, 0x6d, 0x73,
	0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x08, 0x6d, 0x61, 0x78, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x22, 0x4d, 0x0a,
	0x0b, 0x4e, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x0b, 0x0a, 0x07,
	0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x49, 0x4e,
	0x47, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x4c, 0x49, 0x53, 0x54, 0x10, 0x02, 0x12,
	0x07, 0x0a, 0x03, 0x53, 0x45, 0x54, 0x10, 0x03, 0x12, 0x07, 0x0a, 0x03, 0x4d, 0x41, 0x50, 0x10,
	0x04, 0x12, 0x09, 0x0a, 0x05, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x10, 0x05, 0x1a, 0x8b, 0x02, 0x0a,
	0x06, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x3b, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x74, 0x66,
	0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x12, 0x3e, 0x0a, 0x07, 0x6e, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x36, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x2e,
	0x4e, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x07, 0x6e, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x67, 0x12, 0x1f, 0x0a, 0x09, 0x6d, 0x69, 0x6e, 0x5f, 0x69, 0x74, 0x65, 0x6d,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x42, 0x02, 0x18, 0x01, 0x52, 0x08, 0x6d, 0x69, 0x6e,
	0x49, 0x74, 0x65, 0x6d, 0x73, 0x12, 0x1f, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f, 0x69, 0x74, 0x65,
	0x6d, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x42, 0x02, 0x18, 0x01, 0x52, 0x08, 0x6d, 0x61,
	0x78, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x22, 0x42, 0x0a, 0x0b, 0x4e, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x67, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x49, 0x4e, 0x47, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x08,
	0x0a, 0x04, 0x4c, 0x49, 0x53, 0x54, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03, 0x53, 0x45, 0x54, 0x10,
	0x03, 0x12, 0x07, 0x0a, 0x03, 0x4d, 0x41, 0x50, 0x10, 0x04, 0x22, 0x8e, 0x05, 0x0a, 0x08, 0x46,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x74, 0x66,
	0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x4c, 0x0a, 0x12, 0x76, 0x61, 0x72, 0x69, 0x61, 0x64,
	0x69, 0x63, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x46,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x52, 0x11, 0x76, 0x61, 0x72, 0x69, 0x61, 0x64, 0x69, 0x63, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x12, 0x32, 0x0a, 0x06, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36,
	0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e,
	0x52, 0x06, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x75, 0x6d, 0x6d,
	0x61, 0x72, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61,
	0x72, 0x79, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x10, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x15,
	0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x4b, 0x69, 0x6e, 0x64, 0x52, 0x0f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x4b, 0x69, 0x6e, 0x64, 0x12, 0x2f, 0x0a, 0x13, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x12, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x1a, 0xf3, 0x01, 0x0a, 0x09, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x28, 0x0a,
	0x10, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6e, 0x75, 0x6c, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4e, 0x75,
	0x6c, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x5f, 0x75, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x55, 0x6e, 0x6b, 0x6e,
	0x6f, 0x77, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x10, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x69, 0x6e, 0x64, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x15, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x36, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x4b, 0x69, 0x6e, 0x64, 0x52, 0x0f, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x69, 0x6e, 0x64, 0x1a, 0x1c, 0x0a,
	0x06, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0xa8, 0x01, 0x0a, 0x12,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69,
	0x65, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x72,
	0x6f, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x70, 0x6c, 0x61, 0x6e, 0x44, 0x65,
	0x73, 0x74, 0x72, 0x6f, 0x79, 0x12, 0x3f, 0x0a, 0x1c, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f,
	0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x6f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x19, 0x67, 0x65, 0x74,
	0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x12, 0x2e, 0x0a, 0x13, 0x6d, 0x6f, 0x76, 0x65, 0x5f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x11, 0x6d, 0x6f, 0x76, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x22, 0x82, 0x01, 0x0a, 0x12, 0x43, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x29, 0x0a,
	0x10, 0x64, 0x65, 0x66, 0x65, 0x72, 0x72, 0x61, 0x6c, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x64, 0x65, 0x66, 0x65, 0x72, 0x72, 0x61,
	0x6c, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x12, 0x41, 0x0a, 0x1d, 0x77, 0x72, 0x69, 0x74,
	0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x1a, 0x77, 0x72, 0x69, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x22, 0xa2, 0x01, 0x0a, 0x08,
	0x44, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x12, 0x32, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x2e, 0x52, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x22, 0x62, 0x0a, 0x06,
	0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57,
	0x4e, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f,
	0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x01,
	0x12, 0x1b, 0x0a, 0x17, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x44, 0x45, 0x52, 0x5f, 0x43, 0x4f, 0x4e,
	0x46, 0x49, 0x47, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x02, 0x12, 0x11, 0x0a,
	0x0d, 0x41, 0x42, 0x53, 0x45, 0x4e, 0x54, 0x5f, 0x50, 0x52, 0x45, 0x52, 0x45, 0x51, 0x10, 0x03,
	0x22, 0xb3, 0x05, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x1a, 0x09, 0x0a, 0x07, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0xd2, 0x03, 0x0a, 0x08,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4e, 0x0a, 0x13, 0x73, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x36, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x52, 0x12, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x70, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x37, 0x0a, 0x0b, 0x64, 0x69, 0x61, 0x67,
	0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e,
	0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f,
	0x73, 0x74, 0x69, 0x63, 0x52, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63,
	0x73, 0x12, 0x4c, 0x0a, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x36, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x52, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12,
	0x45, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x47,
	0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x09, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x45, 0x0a, 0x09, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x74, 0x66, 0x70, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x52, 0x09, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x61, 0x0a,
	0x13, 0x65, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x74, 0x66, 0x70,
	0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x45, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x12, 0x65, 0x70,
	0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x1a, 0x26, 0x0a, 0x10, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0x31, 0x0a, 0x12, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1b,
	0x0a, 0x09, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x74, 0x79, 0x70, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x2f, 0x0a, 0x10, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x1b, 0x0a, 0x09, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x74, 0x79, 0x70, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x38, 0x0a, 0x19,
	0x45, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x79, 0x70,
	0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x79,
	0x70, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xab, 0x08, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x50, 0x72,
	0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x1a, 0x09, 0x0a, 0x07,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x8a, 0x08, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2d, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x36, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x76, 0x69,
	0x64, 0x65, 0x72, 0x12, 0x65, 0x0a, 0x10, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e,
	0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f,
	0x76, 0x69, 0x64, 0x65, 0x72, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x12, 0x6c, 0x0a, 0x13, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x36, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x11, 0x64, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x12, 0x37, 0x0a, 0x0b, 0x64, 0x69, 0x61, 0x67,
	0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e,
	0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f,
	0x73, 0x74, 0x69, 0x63, 0x52, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63,
	0x73, 0x12, 0x36, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x6d, 0x65,
	0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x36, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x0c, 0x70, 0x72, 0x6f,
	0x76, 0x69, 0x64, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x4e, 0x0a, 0x13, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x36, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x12, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x70,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x52, 0x0a, 0x09, 0x66, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x74,
	0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x76,
	0x69, 0x64, 0x65, 0x72, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x09, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x81, 0x01,
	0x0a, 0x1a, 0x65, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x18, 0x08, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x43, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x47,
	0x65, 0x74, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x45, 0x70, 0x68, 0x65, 0x6d, 0x65,
	0x72, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x18, 0x65, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72,
	0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x73, 0x1a, 0x55, 0x0a, 0x14, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x27, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74, 0x66, 0x70,
	0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x57, 0x0a, 0x16, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x27, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x1a, 0x51, 0x0a, 0x0e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x29, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36,
	0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x1a, 0x5e, 0x0a, 0x1d, 0x45, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61,
	0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x27, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x36, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x99, 0x01, 0x0a, 0x16, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a,
	0x3a, 0x0a, 0x07, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2f, 0x0a, 0x06, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x66, 0x70,
	0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x43, 0x0a, 0x08, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e,
	0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x74,
	0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73,
	0x74, 0x69, 0x63, 0x52, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73,
	0x22, 0x90, 0x02, 0x0a, 0x14, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x1a, 0x72, 0x0a, 0x07, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x79, 0x70, 0x65, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x0a, 0x09, 0x72,
	0x61, 0x77, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13,
	0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x52, 0x61, 0x77, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x52, 0x08, 0x72, 0x61, 0x77, 0x53, 0x74, 0x61, 0x74, 0x65, 0x1a, 0x83, 0x01,
	0x0a, 0x08, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3e, 0x0a, 0x0e, 0x75, 0x70,
	0x67, 0x72, 0x61, 0x64, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44,
	0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x75, 0x70, 0x67,
	0x72, 0x61, 0x64, 0x65, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x37, 0x0a, 0x0b, 0x64, 0x69,
	0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x15, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x69, 0x61, 0x67,
	0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x52, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74,
	0x69, 0x63, 0x73, 0x22, 0x87, 0x02, 0x0a, 0x16, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0xa7,
	0x01, 0x0a, 0x07, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x79,
	0x70, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74,
	0x79, 0x70, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2f, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x36, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4e, 0x0a, 0x13, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x36, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x52, 0x12, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x70, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x1a, 0x43, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74,
	0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x74, 0x66, 0x70, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63,
	0x52, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x22, 0xba, 0x01,
	0x0a, 0x1a, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x57, 0x0a, 0x07,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x79, 0x70, 0x65, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x79, 0x70, 0x65,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2f, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36,
	0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x43, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x37, 0x0a, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x36, 0x2e, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x52, 0x0b, 0x64,
	0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x22, 0x92, 0x02, 0x0a, 0x11, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72,
	0x1a, 0xb7, 0x01, 0x0a, 0x07, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x11,
	0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f,
	0x72, 0x6d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x06, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x66, 0x70, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4e, 0x0a, 0x13, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x36, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x12, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x61,
	0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x1a, 0x43, 0x0a, 0x08, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f,
	0x73, 0x74, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x74, 0x66,
	0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74,
	0x69, 0x63, 0x52, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x22,
	0xe4, 0x03, 0x0a, 0x0c, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x1a, 0x8c, 0x02, 0x0a, 0x07, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x74, 0x79, 0x70, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x74, 0x79, 0x70, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3c, 0x0a, 0x0d, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x79, 0x6e,
	0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x63, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x12, 0x3c, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x6d, 0x65,
	0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x0c, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x12,
	0x4e, 0x0a, 0x13, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x74,
	0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43,
	0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x12, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x1a,
	0xc4, 0x01, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x34, 0x0a, 0x09,
	0x6e, 0x65, 0x77, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x79, 0x6e, 0x61,
	0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x6e, 0x65, 0x77, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x37, 0x0a, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x36, 0x2e, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x52, 0x0b,
	0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x12, 0x2f, 0x0a, 0x08, 0x64, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65,
	0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x36, 0x2e, 0x44, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x52, 0x08, 0x64, 0x65,
	0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x22, 0xf3, 0x05, 0x0a, 0x12, 0x50, 0x6c, 0x61, 0x6e, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x1a, 0x8b, 0x03,
	0x0a, 0x07, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x79, 0x70,
	0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x79,
	0x70, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x38, 0x0a, 0x0b, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x66,
	0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x45, 0x0a, 0x12, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x5f, 0x6e, 0x65, 0x77,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74,
	0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x10, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x4e,
	0x65, 0x77, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2f, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x36, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x72, 0x69, 0x6f,
	0x72, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x0c, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x12, 0x3c, 0x0a,
	0x0d, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36,
	0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x70,
	0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x4e, 0x0a, 0x13, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69,
	0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x36, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x70, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x12, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43,
	0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x1a, 0xce, 0x02, 0x0a, 0x08,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a, 0x0d, 0x70, 0x6c, 0x61, 0x6e,
	0x6e, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x79, 0x6e, 0x61,
	0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65,
	0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x43, 0x0a, 0x10, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72,
	0x65, 0x73, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x18, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x50, 0x61, 0x74, 0x68, 0x52, 0x0f, 0x72, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x73, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x70,
	0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x0e, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x50, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x12, 0x37, 0x0a, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74,
	0x69, 0x63, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x74, 0x66, 0x70, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63,
	0x52, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x12, 0x2c, 0x0a,
	0x12, 0x6c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x73, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x6c, 0x65, 0x67, 0x61, 0x63,
	0x79, 0x54, 0x79, 0x70, 0x65, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x12, 0x2f, 0x0a, 0x08, 0x64,
	0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e,
	0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x65, 0x66, 0x65, 0x72, 0x72,
	0x65, 0x64, 0x52, 0x08, 0x64, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x22, 0x92, 0x04, 0x0a,
	0x13, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x1a, 0xb6, 0x02, 0x0a, 0x07, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x1b, 0x0a, 0x09, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x79, 0x70, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x38, 0x0a,
	0x0b, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44,
	0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x70, 0x72, 0x69,
	0x6f, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3c, 0x0a, 0x0d, 0x70, 0x6c, 0x61, 0x6e, 0x6e,
	0x65, 0x64, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d,
	0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2f, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x36, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65,
	0x64, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x0e, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x12,
	0x3c, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x6d, 0x65, 0x74, 0x61,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x36, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x0c, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x1a, 0xc1, 0x01,
	0x0a, 0x08, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x34, 0x0a, 0x09, 0x6e, 0x65,
	0x77, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69,
	0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x6e, 0x65, 0x77, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x07, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x12, 0x37, 0x0a, 0x0b, 0x64, 0x69,
	0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x15, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x69, 0x61, 0x67,
	0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x52, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74,
	0x69, 0x63, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x6c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x10, 0x6c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x54, 0x79, 0x70, 0x65, 0x53, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x22, 0xef, 0x03, 0x0a, 0x13, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x1a, 0x86, 0x01, 0x0a, 0x07, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x79, 0x70, 0x65, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02,
	0x69, 0x64, 0x12, 0x4e, 0x0a, 0x13, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x61, 0x70,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1d, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x43, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x12,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69,
	0x65, 0x73, 0x1a, 0x78, 0x0a, 0x10, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x79, 0x70, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44,
	0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x07, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x1a, 0xd4, 0x01, 0x0a,
	0x08, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5e, 0x0a, 0x12, 0x69, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x36, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x11, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x37, 0x0a, 0x0b, 0x64, 0x69, 0x61,
	0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15,
	0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x69, 0x61, 0x67, 0x6e,
	0x6f, 0x73, 0x74, 0x69, 0x63, 0x52, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69,
	0x63, 0x73, 0x12, 0x2f, 0x0a, 0x08, 0x64, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36,
	0x2e, 0x44, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x52, 0x08, 0x64, 0x65, 0x66, 0x65, 0x72,
	0x72, 0x65, 0x64, 0x22, 0xe7, 0x03, 0x0a, 0x11, 0x4d, 0x6f, 0x76, 0x65, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x1a, 0xa8, 0x02, 0x0a, 0x07, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x36, 0x0a, 0x17, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x72,
	0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x28, 0x0a,
	0x10, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x32, 0x0a, 0x15, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x36, 0x0a, 0x0c, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x13, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x52, 0x61,
	0x77, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a,
	0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x1a, 0xa6, 0x01, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x3a, 0x0a, 0x0c, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x36, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x37, 0x0a,
	0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x15, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44,
	0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x52, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e,
	0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0d,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x22, 0x9e, 0x03,
	0x0a, 0x0e, 0x52, 0x65, 0x61, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x1a, 0xe5, 0x01, 0x0a, 0x07, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x74, 0x79, 0x70, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x74, 0x79, 0x70, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2f, 0x0a, 0x06, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x66, 0x70, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3c, 0x0a, 0x0d, 0x70, 0x72,
	0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x79,
	0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x70, 0x72, 0x6f, 0x76,
	0x69, 0x64, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x4e, 0x0a, 0x13, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x36, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x52, 0x12, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x70, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x1a, 0xa3, 0x01, 0x0a, 0x08, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2d, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36,
	0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x37, 0x0a, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74,
	0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x74, 0x66, 0x70, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63,
	0x52, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x12, 0x2f, 0x0a,
	0x08, 0x64, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x13, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x65, 0x66, 0x65,
	0x72, 0x72, 0x65, 0x64, 0x52, 0x08, 0x64, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x22, 0x81,
	0x02, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a,
	0x09, 0x0a, 0x07, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0xe5, 0x01, 0x0a, 0x08, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4d, 0x0a, 0x09, 0x66, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x74, 0x66, 0x70,
	0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x47, 0x65, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x46, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x09, 0x66, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x37, 0x0a, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f,
	0x73, 0x74, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x74, 0x66,
	0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74,
	0x69, 0x63, 0x52, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x1a,
	0x51, 0x0a, 0x0e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x29, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x13, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x46,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0xd1, 0x01, 0x0a, 0x0c, 0x43, 0x61, 0x6c, 0x6c, 0x46, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x1a, 0x54, 0x0a, 0x07, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x35, 0x0a, 0x09, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x36, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09,
	0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0x6b, 0x0a, 0x08, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2f, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x36, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x2e, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x36, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52,
	0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0xbf, 0x01, 0x0a, 0x1f, 0x56, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x45, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x57, 0x0a, 0x07, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x79, 0x70, 0x65, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x2f, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44,
	0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x1a, 0x43, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x37, 0x0a, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36,
	0x2e, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x52, 0x0b, 0x64, 0x69, 0x61,
	0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x22, 0xdd, 0x03, 0x0a, 0x15, 0x4f, 0x70, 0x65,
	0x6e, 0x45, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x1a, 0xa7, 0x01, 0x0a, 0x07, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x74, 0x79, 0x70, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2f, 0x0a, 0x06, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x66,
	0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4e, 0x0a, 0x13,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x74, 0x66, 0x70, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x70, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x12, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x1a, 0x99, 0x02, 0x0a,
	0x08, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x0b, 0x64, 0x69, 0x61,
	0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15,
	0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x69, 0x61, 0x67, 0x6e,
	0x6f, 0x73, 0x74, 0x69, 0x63, 0x52, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69,
	0x63, 0x73, 0x12, 0x3a, 0x0a, 0x08, 0x72, 0x65, 0x6e, 0x65, 0x77, 0x5f, 0x61, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x48, 0x00, 0x52, 0x07, 0x72, 0x65, 0x6e, 0x65, 0x77, 0x41, 0x74, 0x88, 0x01, 0x01, 0x12, 0x2f,
	0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d,
	0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12,
	0x1d, 0x0a, 0x07, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c,
	0x48, 0x01, 0x52, 0x07, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2f,
	0x0a, 0x08, 0x64, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x13, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x65, 0x66,
	0x65, 0x72, 0x72, 0x65, 0x64, 0x52, 0x08, 0x64, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x42,
	0x0b, 0x0a, 0x09, 0x5f, 0x72, 0x65, 0x6e, 0x65, 0x77, 0x5f, 0x61, 0x74, 0x42, 0x0a, 0x0a, 0x08,
	0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x22, 0xa5, 0x02, 0x0a, 0x16, 0x52, 0x65, 0x6e,
	0x65, 0x77, 0x45, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x1a, 0x51, 0x0a, 0x07, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x74, 0x79, 0x70, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x07,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x1a, 0xb7, 0x01, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69,
	0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x52,
	0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x12, 0x3a, 0x0a, 0x08,
	0x72, 0x65, 0x6e, 0x65, 0x77, 0x5f, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x00, 0x52, 0x07, 0x72, 0x65,
	0x6e, 0x65, 0x77, 0x41, 0x74, 0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a, 0x07, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x01, 0x52, 0x07, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x72, 0x65, 0x6e, 0x65,
	0x77, 0x5f, 0x61, 0x74, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x22, 0xb0, 0x01, 0x0a, 0x16, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x45, 0x70, 0x68, 0x65, 0x6d, 0x65,
	0x72, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x1a, 0x51, 0x0a, 0x07, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x79, 0x70, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x07, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x88,
	0x01, 0x01, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x1a, 0x43,
	0x0a, 0x08, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x0b, 0x64, 0x69,
	0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x15, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x44, 0x69, 0x61, 0x67,
	0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x52, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74,
	0x69, 0x63, 0x73, 0x2a, 0x25, 0x0a, 0x0a, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x4b, 0x69, 0x6e,
	0x64, 0x12, 0x09, 0x0a, 0x05, 0x50, 0x4c, 0x41, 0x49, 0x4e, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08,
	0x4d, 0x41, 0x52, 0x4b, 0x44, 0x4f, 0x57, 0x4e, 0x10, 0x01, 0x32, 0x81, 0x10, 0x0a, 0x08, 0x50,
	0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x4e, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1e, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x36, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x36, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x60, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x50, 0x72,
	0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x24, 0x2e, 0x74,
	0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x76,
	0x69, 0x64, 0x65, 0x72, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x25, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x47,
	0x65, 0x74, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6f, 0x0a, 0x16, 0x56, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x29, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e,
	0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a,
	0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6f, 0x0a, 0x16, 0x56, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x29, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36,
	0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2a, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x56, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x7b, 0x0a, 0x1a, 0x56,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2d, 0x2e, 0x74, 0x66, 0x70, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x36, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74,
	0x61, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x69, 0x0a, 0x14, 0x55, 0x70, 0x67, 0x72,
	0x61, 0x64, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x27, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x55, 0x70, 0x67,
	0x72, 0x61, 0x64, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x74, 0x66, 0x70, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x60, 0x0a, 0x11, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65,
	0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x24, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x36, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x50, 0x72,
	0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25,
	0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x2e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x51, 0x0a, 0x0c, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1f, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x36, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x36, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x63, 0x0a, 0x12, 0x50, 0x6c, 0x61, 0x6e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x25,
	0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x50, 0x6c, 0x61, 0x6e, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x36, 0x2e, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x66, 0x0a,
	0x13, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x12, 0x26, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36,
	0x2e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x74,
	0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x66, 0x0a, 0x13, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x26, 0x2e, 0x74,
	0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36,
	0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x60, 0x0a,
	0x11, 0x4d, 0x6f, 0x76, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x24, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x4d,
	0x6f, 0x76, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x36, 0x2e, 0x4d, 0x6f, 0x76, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x57, 0x0a, 0x0e, 0x52, 0x65, 0x61, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x21, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x52, 0x65,
	0x61, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36,
	0x2e, 0x52, 0x65, 0x61, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x8a, 0x01, 0x0a, 0x1f, 0x56, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x45, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x32, 0x2e, 0x74,
	0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x45, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x33, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x56, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x45, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6c, 0x0a, 0x15, 0x4f, 0x70, 0x65, 0x6e, 0x45, 0x70, 0x68,
	0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x28,
	0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x45,
	0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x36, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x45, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72,
	0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x6f, 0x0a, 0x16, 0x52, 0x65, 0x6e, 0x65, 0x77, 0x45, 0x70, 0x68, 0x65,
	0x6d, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x29, 0x2e,
	0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x52, 0x65, 0x6e, 0x65, 0x77, 0x45,
	0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x36, 0x2e, 0x52, 0x65, 0x6e, 0x65, 0x77, 0x45, 0x70, 0x68, 0x65, 0x6d, 0x65,
	0x72, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6f, 0x0a, 0x16, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x45, 0x70, 0x68,
	0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x29,
	0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x43, 0x6c, 0x6f, 0x73, 0x65,
	0x45, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x74, 0x66, 0x70, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x45, 0x70, 0x68, 0x65, 0x6d,
	0x65, 0x72, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x51, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x46, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1f, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x36, 0x2e, 0x47, 0x65, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x36, 0x2e, 0x47, 0x65, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x51, 0x0a, 0x0c, 0x43, 0x61, 0x6c, 0x6c,
	0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x2e, 0x74, 0x66, 0x70, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x36, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x74, 0x66, 0x70, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x51, 0x0a, 0x0c, 0x53,
	0x74, 0x6f, 0x70, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x1f, 0x2e, 0x74, 0x66,
	0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x53, 0x74, 0x6f, 0x70, 0x50, 0x72, 0x6f, 0x76,
	0x69, 0x64, 0x65, 0x72, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x74,
	0x66, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x2e, 0x53, 0x74, 0x6f, 0x70, 0x50, 0x72, 0x6f,
	0x76, 0x69, 0x64, 0x65, 0x72, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x47,
	0x5a, 0x45, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2f, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d,
	0x2d, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2d, 0x67, 0x6f, 0x2f, 0x74, 0x66, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x76, 0x36, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2f, 0x74, 0x66,
	0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x36, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_tfplugin6_proto_rawDescOnce sync.Once
	file_tfplugin6_proto_rawDescData = file_tfplugin6_proto_rawDesc
)

func file_tfplugin6_proto_rawDescGZIP() []byte {
	file_tfplugin6_proto_rawDescOnce.Do(func() {
		file_tfplugin6_proto_rawDescData = protoimpl.X.CompressGZIP(file_tfplugin6_proto_rawDescData)
	})
	return file_tfplugin6_proto_rawDescData
}

var file_tfplugin6_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_tfplugin6_proto_msgTypes = make([]protoimpl.MessageInfo, 88)
var file_tfplugin6_proto_goTypes = []any{
	(StringKind)(0),                                  // 0: tfplugin6.StringKind
	(Diagnostic_Severity)(0),                         // 1: tfplugin6.Diagnostic.Severity
	(Schema_NestedBlock_NestingMode)(0),              // 2: tfplugin6.Schema.NestedBlock.NestingMode
	(Schema_Object_NestingMode)(0),                   // 3: tfplugin6.Schema.Object.NestingMode
	(Deferred_Reason)(0),                             // 4: tfplugin6.Deferred.Reason
	(*DynamicValue)(nil),                             // 5: tfplugin6.DynamicValue
	(*Diagnostic)(nil),                               // 6: tfplugin6.Diagnostic
	(*FunctionError)(nil),                            // 7: tfplugin6.FunctionError
	(*AttributePath)(nil),                            // 8: tfplugin6.AttributePath
	(*StopProvider)(nil),                             // 9: tfplugin6.StopProvider
	(*RawState)(nil),                                 // 10: tfplugin6.RawState
	(*Schema)(nil),                                   // 11: tfplugin6.Schema
	(*Function)(nil),                                 // 12: tfplugin6.Function
	(*ServerCapabilities)(nil),                       // 13: tfplugin6.ServerCapabilities
	(*ClientCapabilities)(nil),                       // 14: tfplugin6.ClientCapabilities
	(*Deferred)(nil),                                 // 15: tfplugin6.Deferred
	(*GetMetadata)(nil),                              // 16: tfplugin6.GetMetadata
	(*GetProviderSchema)(nil),                        // 17: tfplugin6.GetProviderSchema
	(*ValidateProviderConfig)(nil),                   // 18: tfplugin6.ValidateProviderConfig
	(*UpgradeResourceState)(nil),                     // 19: tfplugin6.UpgradeResourceState
	(*ValidateResourceConfig)(nil),                   // 20: tfplugin6.ValidateResourceConfig
	(*ValidateDataResourceConfig)(nil),               // 21: tfplugin6.ValidateDataResourceConfig
	(*ConfigureProvider)(nil),                        // 22: tfplugin6.ConfigureProvider
	(*ReadResource)(nil),                             // 23: tfplugin6.ReadResource
	(*PlanResourceChange)(nil),                       // 24: tfplugin6.PlanResourceChange
	(*ApplyResourceChange)(nil),                      // 25: tfplugin6.ApplyResourceChange
	(*ImportResourceState)(nil),                      // 26: tfplugin6.ImportResourceState
	(*MoveResourceState)(nil),                        // 27: tfplugin6.MoveResourceState
	(*ReadDataSource)(nil),                           // 28: tfplugin6.ReadDataSource
	(*GetFunctions)(nil),                             // 29: tfplugin6.GetFunctions
	(*CallFunction)(nil),                             // 30: tfplugin6.CallFunction
	(*ValidateEphemeralResourceConfig)(nil),          // 31: tfplugin6.ValidateEphemeralResourceConfig
	(*OpenEphemeralResource)(nil),                    // 32: tfplugin6.OpenEphemeralResource
	(*RenewEphemeralResource)(nil),                   // 33: tfplugin6.RenewEphemeralResource
	(*CloseEphemeralResource)(nil),                   // 34: tfplugin6.CloseEphemeralResource
	(*AttributePath_Step)(nil),                       // 35: tfplugin6.AttributePath.Step
	(*StopProvider_Request)(nil),                     // 36: tfplugin6.StopProvider.Request
	(*StopProvider_Response)(nil),                    // 37: tfplugin6.StopProvider.Response
	nil,                                              // 38: tfplugin6.RawState.FlatmapEntry
	(*Schema_Block)(nil),                             // 39: tfplugin6.Schema.Block
	(*Schema_Attribute)(nil),                         // 40: tfplugin6.Schema.Attribute
	(*Schema_NestedBlock)(nil),                       // 41: tfplugin6.Schema.NestedBlock
	(*Schema_Object)(nil),                            // 42: tfplugin6.Schema.Object
	(*Function_Parameter)(nil),                       // 43: tfplugin6.Function.Parameter
	(*Function_Return)(nil),                          // 44: tfplugin6.Function.Return
	(*GetMetadata_Request)(nil),                      // 45: tfplugin6.GetMetadata.Request
	(*GetMetadata_Response)(nil),                     // 46: tfplugin6.GetMetadata.Response
	(*GetMetadata_FunctionMetadata)(nil),             // 47: tfplugin6.GetMetadata.FunctionMetadata
	(*GetMetadata_DataSourceMetadata)(nil),           // 48: tfplugin6.GetMetadata.DataSourceMetadata
	(*GetMetadata_ResourceMetadata)(nil),             // 49: tfplugin6.GetMetadata.ResourceMetadata
	(*GetMetadata_EphemeralResourceMetadata)(nil),    // 50: tfplugin6.GetMetadata.EphemeralResourceMetadata
	(*GetProviderSchema_Request)(nil),                // 51: tfplugin6.GetProviderSchema.Request
	(*GetProviderSchema_Response)(nil),               // 52: tfplugin6.GetProviderSchema.Response
	nil,                                              // 53: tfplugin6.GetProviderSchema.Response.ResourceSchemasEntry
	nil,                                              // 54: tfplugin6.GetProviderSchema.Response.DataSourceSchemasEntry
	nil,                                              // 55: tfplugin6.GetProviderSchema.Response.FunctionsEntry
	nil,                                              // 56: tfplugin6.GetProviderSchema.Response.EphemeralResourceSchemasEntry
	(*ValidateProviderConfig_Request)(nil),           // 57: tfplugin6.ValidateProviderConfig.Request
	(*ValidateProviderConfig_Response)(nil),          // 58: tfplugin6.ValidateProviderConfig.Response
	(*UpgradeResourceState_Request)(nil),             // 59: tfplugin6.UpgradeResourceState.Request
	(*UpgradeResourceState_Response)(nil),            // 60: tfplugin6.UpgradeResourceState.Response
	(*ValidateResourceConfig_Request)(nil),           // 61: tfplugin6.ValidateResourceConfig.Request
	(*ValidateResourceConfig_Response)(nil),          // 62: tfplugin6.ValidateResourceConfig.Response
	(*ValidateDataResourceConfig_Request)(nil),       // 63: tfplugin6.ValidateDataResourceConfig.Request
	(*ValidateDataResourceConfig_Response)(nil),      // 64: tfplugin6.ValidateDataResourceConfig.Response
	(*ConfigureProvider_Request)(nil),                // 65: tfplugin6.ConfigureProvider.Request
	(*ConfigureProvider_Response)(nil),               // 66: tfplugin6.ConfigureProvider.Response
	(*ReadResource_Request)(nil),                     // 67: tfplugin6.ReadResource.Request
	(*ReadResource_Response)(nil),                    // 68: tfplugin6.ReadResource.Response
	(*PlanResourceChange_Request)(nil),               // 69: tfplugin6.PlanResourceChange.Request
	(*PlanResourceChange_Response)(nil),              // 70: tfplugin6.PlanResourceChange.Response
	(*ApplyResourceChange_Request)(nil),              // 71: tfplugin6.ApplyResourceChange.Request
	(*ApplyResourceChange_Response)(nil),             // 72: tfplugin6.ApplyResourceChange.Response
	(*ImportResourceState_Request)(nil),              // 73: tfplugin6.ImportResourceState.Request
	(*ImportResourceState_ImportedResource)(nil),     // 74: tfplugin6.ImportResourceState.ImportedResource
	(*ImportResourceState_Response)(nil),             // 75: tfplugin6.ImportResourceState.Response
	(*MoveResourceState_Request)(nil),                // 76: tfplugin6.MoveResourceState.Request
	(*MoveResourceState_Response)(nil),               // 77: tfplugin6.MoveResourceState.Response
	(*ReadDataSource_Request)(nil),                   // 78: tfplugin6.ReadDataSource.Request
	(*ReadDataSource_Response)(nil),                  // 79: tfplugin6.ReadDataSource.Response
	(*GetFunctions_Request)(nil),                     // 80: tfplugin6.GetFunctions.Request
	(*GetFunctions_Response)(nil),                    // 81: tfplugin6.GetFunctions.Response
	nil,                                              // 82: tfplugin6.GetFunctions.Response.FunctionsEntry
	(*CallFunction_Request)(nil),                     // 83: tfplugin6.CallFunction.Request
	(*CallFunction_Response)(nil),                    // 84: tfplugin6.CallFunction.Response
	(*ValidateEphemeralResourceConfig_Request)(nil),  // 85: tfplugin6.ValidateEphemeralResourceConfig.Request
	(*ValidateEphemeralResourceConfig_Response)(nil), // 86: tfplugin6.ValidateEphemeralResourceConfig.Response
	(*OpenEphemeralResource_Request)(nil),            // 87: tfplugin6.OpenEphemeralResource.Request
	(*OpenEphemeralResource_Response)(nil),           // 88: tfplugin6.OpenEphemeralResource.Response
	(*RenewEphemeralResource_Request)(nil),           // 89: tfplugin6.RenewEphemeralResource.Request
	(*RenewEphemeralResource_Response)(nil),          // 90: tfplugin6.RenewEphemeralResource.Response
	(*CloseEphemeralResource_Request)(nil),           // 91: tfplugin6.CloseEphemeralResource.Request
	(*CloseEphemeralResource_Response)(nil),          // 92: tfplugin6.CloseEphemeralResource.Response
	(*timestamppb.Timestamp)(nil),                    // 93: google.protobuf.Timestamp
}
var file_tfplugin6_proto_depIdxs = []int32{
	1,   // 0: tfplugin6.Diagnostic.severity:type_name -> tfplugin6.Diagnostic.Severity
	8,   // 1: tfplugin6.Diagnostic.attribute:type_name -> tfplugin6.AttributePath
	35,  // 2: tfplugin6.AttributePath.steps:type_name -> tfplugin6.AttributePath.Step
	38,  // 3: tfplugin6.RawState.flatmap:type_name -> tfplugin6.RawState.FlatmapEntry
	39,  // 4: tfplugin6.Schema.block:type_name -> tfplugin6.Schema.Block
	43,  // 5: tfplugin6.Function.parameters:type_name -> tfplugin6.Function.Parameter
	43,  // 6: tfplugin6.Function.variadic_parameter:type_name -> tfplugin6.Function.Parameter
	44,  // 7: tfplugin6.Function.return:type_name -> tfplugin6.Function.Return
	0,   // 8: tfplugin6.Function.description_kind:type_name -> tfplugin6.StringKind
	4,   // 9: tfplugin6.Deferred.reason:type_name -> tfplugin6.Deferred.Reason
	40,  // 10: tfplugin6.Schema.Block.attributes:type_name -> tfplugin6.Schema.Attribute
	41,  // 11: tfplugin6.Schema.Block.block_types:type_name -> tfplugin6.Schema.NestedBlock
	0,   // 12: tfplugin6.Schema.Block.description_kind:type_name -> tfplugin6.StringKind
	42,  // 13: tfplugin6.Schema.Attribute.nested_type:type_name -> tfplugin6.Schema.Object
	0,   // 14: tfplugin6.Schema.Attribute.description_kind:type_name -> tfplugin6.StringKind
	39,  // 15: tfplugin6.Schema.NestedBlock.block:type_name -> tfplugin6.Schema.Block
	2,   // 16: tfplugin6.Schema.NestedBlock.nesting:type_name -> tfplugin6.Schema.NestedBlock.NestingMode
	40,  // 17: tfplugin6.Schema.Object.attributes:type_name -> tfplugin6.Schema.Attribute
	3,   // 18: tfplugin6.Schema.Object.nesting:type_name -> tfplugin6.Schema.Object.NestingMode
	0,   // 19: tfplugin6.Function.Parameter.description_kind:type_name -> tfplugin6.StringKind
	13,  // 20: tfplugin6.GetMetadata.Response.server_capabilities:type_name -> tfplugin6.ServerCapabilities
	6,   // 21: tfplugin6.GetMetadata.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	48,  // 22: tfplugin6.GetMetadata.Response.data_sources:type_name -> tfplugin6.GetMetadata.DataSourceMetadata
	49,  // 23: tfplugin6.GetMetadata.Response.resources:type_name -> tfplugin6.GetMetadata.ResourceMetadata
	47,  // 24: tfplugin6.GetMetadata.Response.functions:type_name -> tfplugin6.GetMetadata.FunctionMetadata
	50,  // 25: tfplugin6.GetMetadata.Response.ephemeral_resources:type_name -> tfplugin6.GetMetadata.EphemeralResourceMetadata
	11,  // 26: tfplugin6.GetProviderSchema.Response.provider:type_name -> tfplugin6.Schema
	53,  // 27: tfplugin6.GetProviderSchema.Response.resource_schemas:type_name -> tfplugin6.GetProviderSchema.Response.ResourceSchemasEntry
	54,  // 28: tfplugin6.GetProviderSchema.Response.data_source_schemas:type_name -> tfplugin6.GetProviderSchema.Response.DataSourceSchemasEntry
	6,   // 29: tfplugin6.GetProviderSchema.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	11,  // 30: tfplugin6.GetProviderSchema.Response.provider_meta:type_name -> tfplugin6.Schema
	13,  // 31: tfplugin6.GetProviderSchema.Response.server_capabilities:type_name -> tfplugin6.ServerCapabilities
	55,  // 32: tfplugin6.GetProviderSchema.Response.functions:type_name -> tfplugin6.GetProviderSchema.Response.FunctionsEntry
	56,  // 33: tfplugin6.GetProviderSchema.Response.ephemeral_resource_schemas:type_name -> tfplugin6.GetProviderSchema.Response.EphemeralResourceSchemasEntry
	11,  // 34: tfplugin6.GetProviderSchema.Response.ResourceSchemasEntry.value:type_name -> tfplugin6.Schema
	11,  // 35: tfplugin6.GetProviderSchema.Response.DataSourceSchemasEntry.value:type_name -> tfplugin6.Schema
	12,  // 36: tfplugin6.GetProviderSchema.Response.FunctionsEntry.value:type_name -> tfplugin6.Function
	11,  // 37: tfplugin6.GetProviderSchema.Response.EphemeralResourceSchemasEntry.value:type_name -> tfplugin6.Schema
	5,   // 38: tfplugin6.ValidateProviderConfig.Request.config:type_name -> tfplugin6.DynamicValue
	6,   // 39: tfplugin6.ValidateProviderConfig.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	10,  // 40: tfplugin6.UpgradeResourceState.Request.raw_state:type_name -> tfplugin6.RawState
	5,   // 41: tfplugin6.UpgradeResourceState.Response.upgraded_state:type_name -> tfplugin6.DynamicValue
	6,   // 42: tfplugin6.UpgradeResourceState.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	5,   // 43: tfplugin6.ValidateResourceConfig.Request.config:type_name -> tfplugin6.DynamicValue
	14,  // 44: tfplugin6.ValidateResourceConfig.Request.client_capabilities:type_name -> tfplugin6.ClientCapabilities
	6,   // 45: tfplugin6.ValidateResourceConfig.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	5,   // 46: tfplugin6.ValidateDataResourceConfig.Request.config:type_name -> tfplugin6.DynamicValue
	6,   // 47: tfplugin6.ValidateDataResourceConfig.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	5,   // 48: tfplugin6.ConfigureProvider.Request.config:type_name -> tfplugin6.DynamicValue
	14,  // 49: tfplugin6.ConfigureProvider.Request.client_capabilities:type_name -> tfplugin6.ClientCapabilities
	6,   // 50: tfplugin6.ConfigureProvider.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	5,   // 51: tfplugin6.ReadResource.Request.current_state:type_name -> tfplugin6.DynamicValue
	5,   // 52: tfplugin6.ReadResource.Request.provider_meta:type_name -> tfplugin6.DynamicValue
	14,  // 53: tfplugin6.ReadResource.Request.client_capabilities:type_name -> tfplugin6.ClientCapabilities
	5,   // 54: tfplugin6.ReadResource.Response.new_state:type_name -> tfplugin6.DynamicValue
	6,   // 55: tfplugin6.ReadResource.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	15,  // 56: tfplugin6.ReadResource.Response.deferred:type_name -> tfplugin6.Deferred
	5,   // 57: tfplugin6.PlanResourceChange.Request.prior_state:type_name -> tfplugin6.DynamicValue
	5,   // 58: tfplugin6.PlanResourceChange.Request.proposed_new_state:type_name -> tfplugin6.DynamicValue
	5,   // 59: tfplugin6.PlanResourceChange.Request.config:type_name -> tfplugin6.DynamicValue
	5,   // 60: tfplugin6.PlanResourceChange.Request.provider_meta:type_name -> tfplugin6.DynamicValue
	14,  // 61: tfplugin6.PlanResourceChange.Request.client_capabilities:type_name -> tfplugin6.ClientCapabilities
	5,   // 62: tfplugin6.PlanResourceChange.Response.planned_state:type_name -> tfplugin6.DynamicValue
	8,   // 63: tfplugin6.PlanResourceChange.Response.requires_replace:type_name -> tfplugin6.AttributePath
	6,   // 64: tfplugin6.PlanResourceChange.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	15,  // 65: tfplugin6.PlanResourceChange.Response.deferred:type_name -> tfplugin6.Deferred
	5,   // 66: tfplugin6.ApplyResourceChange.Request.prior_state:type_name -> tfplugin6.DynamicValue
	5,   // 67: tfplugin6.ApplyResourceChange.Request.planned_state:type_name -> tfplugin6.DynamicValue
	5,   // 68: tfplugin6.ApplyResourceChange.Request.config:type_name -> tfplugin6.DynamicValue
	5,   // 69: tfplugin6.ApplyResourceChange.Request.provider_meta:type_name -> tfplugin6.DynamicValue
	5,   // 70: tfplugin6.ApplyResourceChange.Response.new_state:type_name -> tfplugin6.DynamicValue
	6,   // 71: tfplugin6.ApplyResourceChange.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	14,  // 72: tfplugin6.ImportResourceState.Request.client_capabilities:type_name -> tfplugin6.ClientCapabilities
	5,   // 73: tfplugin6.ImportResourceState.ImportedResource.state:type_name -> tfplugin6.DynamicValue
	74,  // 74: tfplugin6.ImportResourceState.Response.imported_resources:type_name -> tfplugin6.ImportResourceState.ImportedResource
	6,   // 75: tfplugin6.ImportResourceState.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	15,  // 76: tfplugin6.ImportResourceState.Response.deferred:type_name -> tfplugin6.Deferred
	10,  // 77: tfplugin6.MoveResourceState.Request.source_state:type_name -> tfplugin6.RawState
	5,   // 78: tfplugin6.MoveResourceState.Response.target_state:type_name -> tfplugin6.DynamicValue
	6,   // 79: tfplugin6.MoveResourceState.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	5,   // 80: tfplugin6.ReadDataSource.Request.config:type_name -> tfplugin6.DynamicValue
	5,   // 81: tfplugin6.ReadDataSource.Request.provider_meta:type_name -> tfplugin6.DynamicValue
	14,  // 82: tfplugin6.ReadDataSource.Request.client_capabilities:type_name -> tfplugin6.ClientCapabilities
	5,   // 83: tfplugin6.ReadDataSource.Response.state:type_name -> tfplugin6.DynamicValue
	6,   // 84: tfplugin6.ReadDataSource.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	15,  // 85: tfplugin6.ReadDataSource.Response.deferred:type_name -> tfplugin6.Deferred
	82,  // 86: tfplugin6.GetFunctions.Response.functions:type_name -> tfplugin6.GetFunctions.Response.FunctionsEntry
	6,   // 87: tfplugin6.GetFunctions.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	12,  // 88: tfplugin6.GetFunctions.Response.FunctionsEntry.value:type_name -> tfplugin6.Function
	5,   // 89: tfplugin6.CallFunction.Request.arguments:type_name -> tfplugin6.DynamicValue
	5,   // 90: tfplugin6.CallFunction.Response.result:type_name -> tfplugin6.DynamicValue
	7,   // 91: tfplugin6.CallFunction.Response.error:type_name -> tfplugin6.FunctionError
	5,   // 92: tfplugin6.ValidateEphemeralResourceConfig.Request.config:type_name -> tfplugin6.DynamicValue
	6,   // 93: tfplugin6.ValidateEphemeralResourceConfig.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	5,   // 94: tfplugin6.OpenEphemeralResource.Request.config:type_name -> tfplugin6.DynamicValue
	14,  // 95: tfplugin6.OpenEphemeralResource.Request.client_capabilities:type_name -> tfplugin6.ClientCapabilities
	6,   // 96: tfplugin6.OpenEphemeralResource.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	93,  // 97: tfplugin6.OpenEphemeralResource.Response.renew_at:type_name -> google.protobuf.Timestamp
	5,   // 98: tfplugin6.OpenEphemeralResource.Response.result:type_name -> tfplugin6.DynamicValue
	15,  // 99: tfplugin6.OpenEphemeralResource.Response.deferred:type_name -> tfplugin6.Deferred
	6,   // 100: tfplugin6.RenewEphemeralResource.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	93,  // 101: tfplugin6.RenewEphemeralResource.Response.renew_at:type_name -> google.protobuf.Timestamp
	6,   // 102: tfplugin6.CloseEphemeralResource.Response.diagnostics:type_name -> tfplugin6.Diagnostic
	45,  // 103: tfplugin6.Provider.GetMetadata:input_type -> tfplugin6.GetMetadata.Request
	51,  // 104: tfplugin6.Provider.GetProviderSchema:input_type -> tfplugin6.GetProviderSchema.Request
	57,  // 105: tfplugin6.Provider.ValidateProviderConfig:input_type -> tfplugin6.ValidateProviderConfig.Request
	61,  // 106: tfplugin6.Provider.ValidateResourceConfig:input_type -> tfplugin6.ValidateResourceConfig.Request
	63,  // 107: tfplugin6.Provider.ValidateDataResourceConfig:input_type -> tfplugin6.ValidateDataResourceConfig.Request
	59,  // 108: tfplugin6.Provider.UpgradeResourceState:input_type -> tfplugin6.UpgradeResourceState.Request
	65,  // 109: tfplugin6.Provider.ConfigureProvider:input_type -> tfplugin6.ConfigureProvider.Request
	67,  // 110: tfplugin6.Provider.ReadResource:input_type -> tfplugin6.ReadResource.Request
	69,  // 111: tfplugin6.Provider.PlanResourceChange:input_type -> tfplugin6.PlanResourceChange.Request
	71,  // 112: tfplugin6.Provider.ApplyResourceChange:input_type -> tfplugin6.ApplyResourceChange.Request
	73,  // 113: tfplugin6.Provider.ImportResourceState:input_type -> tfplugin6.ImportResourceState.Request
	76,  // 114: tfplugin6.Provider.MoveResourceState:input_type -> tfplugin6.MoveResourceState.Request
	78,  // 115: tfplugin6.Provider.ReadDataSource:input_type -> tfplugin6.ReadDataSource.Request
	85,  // 116: tfplugin6.Provider.ValidateEphemeralResourceConfig:input_type -> tfplugin6.ValidateEphemeralResourceConfig.Request
	87,  // 117: tfplugin6.Provider.OpenEphemeralResource:input_type -> tfplugin6.OpenEphemeralResource.Request
	89,  // 118: tfplugin6.Provider.RenewEphemeralResource:input_type -> tfplugin6.RenewEphemeralResource.Request
	91,  // 119: tfplugin6.Provider.CloseEphemeralResource:input_type -> tfplugin6.CloseEphemeralResource.Request
	80,  // 120: tfplugin6.Provider.GetFunctions:input_type -> tfplugin6.GetFunctions.Request
	83,  // 121: tfplugin6.Provider.CallFunction:input_type -> tfplugin6.CallFunction.Request
	36,  // 122: tfplugin6.Provider.StopProvider:input_type -> tfplugin6.StopProvider.Request
	46,  // 123: tfplugin6.Provider.GetMetadata:output_type -> tfplugin6.GetMetadata.Response
	52,  // 124: tfplugin6.Provider.GetProviderSchema:output_type -> tfplugin6.GetProviderSchema.Response
	58,  // 125: tfplugin6.Provider.ValidateProviderConfig:output_type -> tfplugin6.ValidateProviderConfig.Response
	62,  // 126: tfplugin6.Provider.ValidateResourceConfig:output_type -> tfplugin6.ValidateResourceConfig.Response
	64,  // 127: tfplugin6.Provider.ValidateDataResourceConfig:output_type -> tfplugin6.ValidateDataResourceConfig.Response
	60,  // 128: tfplugin6.Provider.UpgradeResourceState:output_type -> tfplugin6.UpgradeResourceState.Response
	66,  // 129: tfplugin6.Provider.ConfigureProvider:output_type -> tfplugin6.ConfigureProvider.Response
	68,  // 130: tfplugin6.Provider.ReadResource:output_type -> tfplugin6.ReadResource.Response
	70,  // 131: tfplugin6.Provider.PlanResourceChange:output_type -> tfplugin6.PlanResourceChange.Response
	72,  // 132: tfplugin6.Provider.ApplyResourceChange:output_type -> tfplugin6.ApplyResourceChange.Response
	75,  // 133: tfplugin6.Provider.ImportResourceState:output_type -> tfplugin6.ImportResourceState.Response
	77,  // 134: tfplugin6.Provider.MoveResourceState:output_type -> tfplugin6.MoveResourceState.Response
	79,  // 135: tfplugin6.Provider.ReadDataSource:output_type -> tfplugin6.ReadDataSource.Response
	86,  // 136: tfplugin6.Provider.ValidateEphemeralResourceConfig:output_type -> tfplugin6.ValidateEphemeralResourceConfig.Response
	88,  // 137: tfplugin6.Provider.OpenEphemeralResource:output_type -> tfplugin6.OpenEphemeralResource.Response
	90,  // 138: tfplugin6.Provider.RenewEphemeralResource:output_type -> tfplugin6.RenewEphemeralResource.Response
	92,  // 139: tfplugin6.Provider.CloseEphemeralResource:output_type -> tfplugin6.CloseEphemeralResource.Response
	81,  // 140: tfplugin6.Provider.GetFunctions:output_type -> tfplugin6.GetFunctions.Response
	84,  // 141: tfplugin6.Provider.CallFunction:output_type -> tfplugin6.CallFunction.Response
	37,  // 142: tfplugin6.Provider.StopProvider:output_type -> tfplugin6.StopProvider.Response
	123, // [123:143] is the sub-list for method output_type
	103, // [103:123] is the sub-list for method input_type
	103, // [103:103] is the sub-list for extension type_name
	103, // [103:103] is the sub-list for extension extendee
	0,   // [0:103] is the sub-list for field type_name
}

func init() { file_tfplugin6_proto_init() }
func file_tfplugin6_proto_init() {
	if File_tfplugin6_proto != nil {
		return
	}
	file_tfplugin6_proto_msgTypes[2].OneofWrappers = []any{}
	file_tfplugin6_proto_msgTypes[30].OneofWrappers = []any{
		(*AttributePath_Step_AttributeName)(nil),
		(*AttributePath_Step_ElementKeyString)(nil),
		(*AttributePath_Step_ElementKeyInt)(nil),
	}
	file_tfplugin6_proto_msgTypes[83].OneofWrappers = []any{}
	file_tfplugin6_proto_msgTypes[84].OneofWrappers = []any{}
	file_tfplugin6_proto_msgTypes[85].OneofWrappers = []any{}
	file_tfplugin6_proto_msgTypes[86].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_tfplugin6_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   88,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_tfplugin6_proto_goTypes,
		DependencyIndexes: file_tfplugin6_proto_depIdxs,
		EnumInfos:         file_tfplugin6_proto_enumTypes,
		MessageInfos:      file_tfplugin6_proto_msgTypes,
	}.Build()
	File_tfplugin6_proto = out.File
	file_tfplugin6_proto_rawDesc = nil
	file_tfplugin6_proto_goTypes = nil
	file_tfplugin6_proto_depIdxs = nil
}
